/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.Saver;
import com.atlassian.crucible.migration.item.FileBackupItem;
import com.atlassian.crucible.migration.item.FileSaver;
import com.atlassian.fecru.matcher.FileMatchers;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.IOHelper;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class FileBackupItemTest {
    private File baseDir = null;
    private File zipFile = null;
    private File expectedFile1;
    private File expectedFile2;
    private File expectedFile3;
    private final ProgressMonitor monitor = resource -> {};
    private FileBackupItem fbi = new FileBackupItem(){

        public String getName() {
            return "base";
        }

        public String getDescription() {
            return null;
        }

        public boolean isMandatory() {
            return false;
        }

        public boolean isDefault() {
            return false;
        }

        public Saver getSaver(AutowireCapableBeanFactory beanFactory) {
            return new FileSaver(){

                public void backup(ZipOutputStream zos, ProgressMonitor monitor, Map<String, String> properties) throws IOException {
                    throw new AssertionFailedError("backup not expected to be called");
                }
            };
        }

        public boolean isCrucible() {
            return true;
        }

        public boolean isFishEye() {
            return true;
        }

        public Restorer getRestorer(ZipFile zip, ProgressMonitor monitor, Map<String, String> properties) {
            return null;
        }
    };

    @Before
    public void setUp() throws Exception {
        this.baseDir = FisheyeTestUtil.createTempDir("FileBackupItemTest");
        this.zipFile = new File(this.baseDir, "test.zip");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(this.zipFile));
        zos.putNextEntry(new ZipEntry(this.fbi.getName() + "/file1"));
        IOHelper.copyStream((InputStream)new ByteArrayInputStream("foo".getBytes()), (OutputStream)zos);
        zos.putNextEntry(new ZipEntry(this.fbi.getName() + "/dir1/"));
        zos.putNextEntry(new ZipEntry(this.fbi.getName() + "/dir1/file2"));
        IOHelper.copyStream((InputStream)new ByteArrayInputStream("bar".getBytes()), (OutputStream)zos);
        zos.putNextEntry(new ZipEntry(this.fbi.getName() + "/dir1/subdir1/file3"));
        IOHelper.copyStream((InputStream)new ByteArrayInputStream("baz".getBytes()), (OutputStream)zos);
        zos.close();
        this.expectedFile1 = new File(this.baseDir, "file1");
        this.expectedFile2 = new File(this.baseDir, "dir1/file2");
        this.expectedFile3 = new File(this.baseDir, "dir1/subdir1/file3");
        Assert.assertThat((String)"file should not exist prior to the test", (Object)this.expectedFile1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to the test", (Object)this.expectedFile2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to the test", (Object)this.expectedFile3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
    }

    @After
    public void tearDown() throws Exception {
        FisheyeTestUtil.deleteDir(this.baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModificationTime() throws IOException {
        File tempDir = FisheyeTestUtil.createTempDir("modTimeSrc");
        File sourceFile = new File(tempDir, "fu.bar");
        sourceFile.createNewFile();
        sourceFile.deleteOnExit();
        sourceFile.setLastModified(System.currentTimeMillis() - 86400000L);
        long modificationTime = sourceFile.lastModified();
        File archive = FisheyeTestUtil.createTempFile("modTimeTest");
        archive.deleteOnExit();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(archive));
        FileSaver saver = (FileSaver)this.fbi.getSaver(null);
        saver.setBackupItem((BackupItem)this.fbi);
        saver.addPath(new File("fu.bar"), sourceFile, zos, this.monitor);
        zos.finish();
        zos.close();
        File tempDir2 = FisheyeTestUtil.createTempDir("modTimeDest");
        this.fbi.extractPath("fu.bar", tempDir2, new ZipFile(archive), this.monitor);
        try {
            File destFile = new File(tempDir2, "fu.bar");
            Assert.assertThat((Object)destFile, FileMatchers.exists());
            this.assertMSDOSModificationTime(modificationTime, destFile.lastModified());
        }
        finally {
            FisheyeTestUtil.deleteDir(tempDir);
            FisheyeTestUtil.deleteDir(tempDir2);
        }
    }

    private void assertMSDOSModificationTime(long expected, long actual) {
        long diff = Math.abs(expected - actual);
        junit.framework.Assert.assertTrue((String)("expected = " + expected + ", but actual = " + actual + " (diff > 2s: " + diff + "ms)"), (diff <= 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testExtractAll() throws IOException {
        ZipFile z = new ZipFile(this.zipFile);
        this.fbi.extractPath(null, this.baseDir, z, this.monitor);
        Assert.assertThat((String)"file should be extracted", (Object)this.expectedFile1, FileMatchers.exists());
        Assert.assertThat((String)"file should be extracted", (Object)this.expectedFile2, FileMatchers.exists());
        Assert.assertThat((String)"file should be extracted", (Object)this.expectedFile3, FileMatchers.exists());
        z.close();
    }

    @Test
    public void testNestedFile() throws IOException {
        ZipFile z = new ZipFile(this.zipFile);
        this.fbi.extractPath("dir1/file2", this.baseDir, z, this.monitor);
        Assert.assertThat((String)"file outside defined extraction path should not be extracted", (Object)this.expectedFile1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file within defined extraction path should be extracted", (Object)this.expectedFile2, FileMatchers.exists());
        Assert.assertThat((String)"file outside defined extraction path should not be extracted", (Object)this.expectedFile3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        z.close();
    }

    @Test
    public void testExtractDirectory() throws IOException {
        ZipFile z = new ZipFile(this.zipFile);
        this.fbi.extractPath("dir1", this.baseDir, z, this.monitor);
        Assert.assertThat((String)"file outside defined extraction path should not be extracted", (Object)this.expectedFile1, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file within defined extraction path should be extracted", (Object)this.expectedFile2, FileMatchers.exists());
        Assert.assertThat((String)"file within defined extraction path should be extracted", (Object)this.expectedFile3, FileMatchers.exists());
        z.close();
    }

    @Test
    public void testList() throws Exception {
        ZipFile z = new ZipFile(this.zipFile);
        Collection contents = this.fbi.list("dir1", z);
        Assert.assertThat((Object)contents, (Matcher)Matchers.hasItem((Object)"file2"));
    }
}

