/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeParser;
import com.atlassian.crucible.migration.NodeStreamReader;
import com.atlassian.crucible.migration.ParseException;
import com.atlassian.crucible.migration.item.DBImporter;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.fisheye.AppConfig;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class DBImporterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private NodeStreamReader reader;
    private NodeParser rootNode;
    private DBInfo dbInfo;
    private DBControl controller;

    @Before
    public void setUpMocks() throws ParseException {
        this.reader = (NodeStreamReader)Mockito.mock(NodeStreamReader.class);
        this.rootNode = (NodeParser)Mockito.mock(NodeParser.class);
        this.dbInfo = (DBInfo)Mockito.mock(DBInfo.class);
        this.controller = (DBControl)Mockito.mock(DBControl.class);
        Mockito.when((Object)this.reader.getRootNode()).thenReturn((Object)this.rootNode);
        Mockito.when((Object)this.controller.getInfo()).thenReturn((Object)this.dbInfo);
        Mockito.when((Object)this.dbInfo.state()).thenReturn((Object)DBInfo.DBState.STARTED);
    }

    @Test
    public void canImportOlderBackup() throws Exception {
        this.thrown.expect(PrematurelyExitMethodException.class);
        Mockito.when((Object)this.rootNode.getRequiredAttribute("schemaVersion")).thenReturn((Object)Integer.toString(DbVersion.getDatabaseVersion() - 1));
        Mockito.when((Object)this.controller.getType()).thenReturn((Object)DBType.HSQL);
        ((DBControl)Mockito.doThrow((Throwable)new PrematurelyExitMethodException()).when((Object)this.controller)).createTables(Mockito.anyInt());
        new DBImporter().importData(this.reader, this.controller);
    }

    @Test
    public void canImportCurrentBackup() throws Exception {
        this.thrown.expect(PrematurelyExitMethodException.class);
        Mockito.when((Object)this.rootNode.getRequiredAttribute("schemaVersion")).thenReturn((Object)Integer.toString(DbVersion.getDatabaseVersion()));
        Mockito.when((Object)this.controller.getType()).thenReturn((Object)DBType.HSQL);
        ((DBControl)Mockito.doThrow((Throwable)new PrematurelyExitMethodException()).when((Object)this.controller)).createTables(Mockito.anyInt());
        new DBImporter().importData(this.reader, this.controller);
    }

    @Test
    public void cantImportNewerBackup() throws Exception {
        this.thrown.expect(CruDBException.class);
        this.thrown.expectMessage(String.format("ERROR: This backup archive is from a newer version of %s and cannot be restored in this version (schema %d > %d)...", AppConfig.getProductName(), DbVersion.getDatabaseVersion() + 1, DbVersion.getDatabaseVersion()));
        Mockito.when((Object)this.rootNode.getRequiredAttribute("schemaVersion")).thenReturn((Object)Integer.toString(DbVersion.getDatabaseVersion() + 1));
        Mockito.when((Object)this.controller.getType()).thenReturn((Object)DBType.HSQL);
        new DBImporter().importData(this.reader, this.controller);
    }

    @Test
    public void cantImportBackupUnlessDbSupported() throws Exception {
        this.thrown.expect(CruDBException.class);
        this.thrown.expectMessage(String.format("ERROR: This backup archive is from a version of %s which did not support %s databases (schema version %d < first supported %2$s version %d). You must upgrade your %1$s instance with your previous database, perform a new backup and then re-import.", AppConfig.getProductName(), DBType.ORACLE.getDisplayName(), DBType.ORACLE.getMinimalSchemaVersion() - 1, DBType.ORACLE.getMinimalSchemaVersion()));
        Mockito.when((Object)this.rootNode.getRequiredAttribute("schemaVersion")).thenReturn((Object)Integer.toString(DBType.ORACLE.getMinimalSchemaVersion() - 1));
        Mockito.when((Object)this.controller.getType()).thenReturn((Object)DBType.ORACLE);
        new DBImporter().importData(this.reader, this.controller);
    }

    private class PrematurelyExitMethodException
    extends RuntimeException {
        private PrematurelyExitMethodException() {
        }
    }
}

