/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.item.ConfigurableAnonymisingStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class ConfigurableAnonymisingStreamWriterTest
extends TestCase {
    public void testHashing() {
        ConfigurableAnonymisingStreamWriter.HashingAnonymiser anon = new ConfigurableAnonymisingStreamWriter.HashingAnonymiser();
        ConfigurableAnonymisingStreamWriterTest.assertEquals((String)String.format("%d:%d", "foo".hashCode(), 3), (String)((String)anon.anonymise((Object)"foo")));
        ConfigurableAnonymisingStreamWriterTest.assertNull((Object)anon.anonymise(null));
        ConfigurableAnonymisingStreamWriterTest.assertEquals((Object)new Integer(4), (Object)anon.anonymise((Object)4));
    }

    public void testSubstitution() {
        ConfigurableAnonymisingStreamWriter.SubstitutingAnonymiser anon = new ConfigurableAnonymisingStreamWriter.SubstitutingAnonymiser();
        ConfigurableAnonymisingStreamWriterTest.assertEquals((String)"xxxxx", (String)((String)anon.anonymise((Object)"fubar")));
        ConfigurableAnonymisingStreamWriterTest.assertNull((Object)anon.anonymise(null));
        ConfigurableAnonymisingStreamWriterTest.assertEquals((Object)new Integer(4), (Object)anon.anonymise((Object)4));
    }

    public void testUnknownAnonymiser() {
        try {
            Properties illegal = new Properties();
            illegal.load(new ByteArrayInputStream("# illegal configuration\ntable.column1=hash\ntable.column2=substitute\ntable.column3=illegalAnonymisationMethod".getBytes()));
            new ConfigurableAnonymisingStreamWriter((NodeStreamWriter)EasyMock.createNiceMock(NodeStreamWriter.class), illegal);
            ConfigurableAnonymisingStreamWriterTest.fail();
        }
        catch (IOException ioe) {
            ConfigurableAnonymisingStreamWriterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAnonymisation() throws Exception {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream("table1.column1=hash\n# table1.column2 is not anonymised\ntable1.column3=substitute\n# table2.column1 is not anonymised\ntable2.column2=substitute\n".getBytes()));
        final NodeCreator sink = (NodeCreator)EasyMock.createMock(NodeCreator.class);
        EasyMock.expect((Object)sink.addNode("table")).andReturn((Object)sink);
        sink.addAttribute("name", "table1");
        EasyMock.expect((Object)sink.addNode("column")).andReturn((Object)sink);
        sink.addAttribute("name", "column1");
        EasyMock.expect((Object)sink.addNode("column")).andReturn((Object)sink);
        sink.addAttribute("name", "column2");
        EasyMock.expect((Object)sink.addNode("column")).andReturn((Object)sink);
        sink.addAttribute("name", "column3");
        EasyMock.expect((Object)sink.addNode("row")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("escapedString")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.setContentAsString("fubar".hashCode() + ":5")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("escapedString")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.setContentAsString("fubar")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("escapedString")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.setContentAsString("xxxxx")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.closeEntity()).andReturn((Object)sink);
        EasyMock.expect((Object)sink.closeEntity()).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("table")).andReturn((Object)sink);
        sink.addAttribute("name", "table2");
        EasyMock.expect((Object)sink.addNode("column")).andReturn((Object)sink);
        sink.addAttribute("name", "column1");
        EasyMock.expect((Object)sink.addNode("column")).andReturn((Object)sink);
        sink.addAttribute("name", "column2");
        EasyMock.expect((Object)sink.addNode("row")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("boolean")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.setContentAsBoolean((Boolean)EasyMock.eq((Object)Boolean.TRUE))).andReturn((Object)sink);
        EasyMock.expect((Object)sink.addNode("escapedString")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.setContentAsString("xxxxxx")).andReturn((Object)sink);
        EasyMock.expect((Object)sink.closeEntity()).andReturn((Object)sink);
        EasyMock.expect((Object)sink.closeEntity()).andReturn((Object)sink);
        EasyMock.expect((Object)sink.closeEntity()).andReturn((Object)sink);
        EasyMock.replay((Object[])new Object[]{sink});
        ConfigurableAnonymisingStreamWriter writer = new ConfigurableAnonymisingStreamWriter(new NodeStreamWriter(){

            public NodeCreator addRootNode(String name) {
                return sink;
            }

            public void flush() {
            }

            public void close() {
            }
        }, properties);
        NodeCreator nc = writer.addRootNode("backup");
        nc = nc.addNode("table");
        nc.addAttribute("name", "table1");
        nc = nc.addNode("column");
        nc.addAttribute("name", "column1");
        nc = nc.addNode("column");
        nc.addAttribute("name", "column2");
        nc = nc.addNode("column");
        nc.addAttribute("name", "column3");
        nc = nc.addNode("row");
        nc = nc.addNode("escapedString");
        nc = nc.setContentAsString("fubar");
        nc = nc.addNode("escapedString");
        nc = nc.setContentAsString("fubar");
        nc = nc.addNode("escapedString");
        nc = nc.setContentAsString("fubar");
        nc = nc.closeEntity();
        nc = nc.closeEntity();
        nc = nc.addNode("table");
        nc.addAttribute("name", "table2");
        nc = nc.addNode("column");
        nc.addAttribute("name", "column1");
        nc = nc.addNode("column");
        nc.addAttribute("name", "column2");
        nc = nc.addNode("row");
        nc = nc.addNode("boolean");
        nc = nc.setContentAsBoolean(Boolean.valueOf(true));
        nc = nc.addNode("escapedString");
        nc = nc.setContentAsString("foobar");
        nc = nc.closeEntity();
        nc = nc.closeEntity();
        nc = nc.closeEntity();
        EasyMock.verify((Object[])new Object[]{sink});
    }
}

