/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.explorers;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.SimpleCrucibleChangeSetsHelper;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SimpleCrucibleChangeSetsHelperTest {
    private SimpleCrucibleChangeSetsHelper helper;
    private SourceFactory sourceFactoryMock;
    private EffectiveUserProvider effectiveUserProviderMock;
    private Source sourceMock;
    private Principal principalMock;
    private int oldLimit;

    @Before
    public void setUp() throws Exception {
        this.oldLimit = CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT;
        CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT = 5;
        this.sourceFactoryMock = (SourceFactory)Mockito.mock(SourceFactory.class);
        this.effectiveUserProviderMock = (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class);
        this.helper = new SimpleCrucibleChangeSetsHelper(this.effectiveUserProviderMock, this.sourceFactoryMock);
        this.sourceMock = (Source)Mockito.mock(Source.class);
        this.principalMock = (Principal)Mockito.mock(Principal.class);
    }

    @After
    public void tearDown() throws Exception {
        CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT = this.oldLimit;
    }

    @Test
    public void testCheckSize() throws Exception {
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someRepo", (String)"123"));
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someOtherRepo", (String)"999"));
        Mockito.when((Object)this.effectiveUserProviderMock.getEffectivePrincipal()).thenReturn((Object)this.principalMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someOtherRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceMock.isAvailable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.isChangesetCapable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("123")).thenReturn((Object)3);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("999")).thenReturn((Object)4);
        try {
            this.helper.checkSize();
            Assert.fail((String)"Expected exception on size over the limit");
        }
        catch (ChangeSetContentTooLargeException e) {
            Assert.assertThat((String)"current limit should be reported", (Object)e.getFilePathLimit(), (Matcher)CoreMatchers.is((Object)5));
        }
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.never())).getChangeSet(org.mockito.Matchers.anyString());
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isAvailable();
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isChangesetCapable();
    }

    @Test
    public void testCreateChangeSets() throws Exception {
        CrucibleChangeSet ccs123 = new CrucibleChangeSet("123", "123", null, null, null, null, null);
        CrucibleChangeSet ccs999 = new CrucibleChangeSet("999", "999", null, null, null, null, null);
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someRepo", (String)"123"));
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someOtherRepo", (String)"999"));
        Mockito.when((Object)this.effectiveUserProviderMock.getEffectivePrincipal()).thenReturn((Object)this.principalMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someOtherRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceMock.isAvailable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.isChangesetCapable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("123")).thenReturn((Object)2);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("999")).thenReturn((Object)1);
        Mockito.when((Object)this.sourceMock.getChangeSet("123")).thenReturn((Object)ccs123);
        Mockito.when((Object)this.sourceMock.getChangeSet("999")).thenReturn((Object)ccs999);
        List changeSets = this.helper.createChangeSets(true);
        Assert.assertThat((Object)changeSets, (Matcher)Matchers.hasItems((Object[])new CrucibleChangeSet[]{ccs123, ccs999}));
        Assert.assertThat((String)"exactly 2 crucible changesets retrieved", (Object)changeSets.size(), (Matcher)CoreMatchers.is((Object)2));
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)4))).isAvailable();
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)4))).isChangesetCapable();
    }

    @Test
    public void testCreateChangeSets_LimitExceeded() throws Exception {
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someRepo", (String)"123"));
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someOtherRepo", (String)"999"));
        Mockito.when((Object)this.effectiveUserProviderMock.getEffectivePrincipal()).thenReturn((Object)this.principalMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someOtherRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceMock.isAvailable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.isChangesetCapable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("123")).thenReturn((Object)3);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("999")).thenReturn((Object)4);
        try {
            List changeSets = this.helper.createChangeSets(true);
            Assert.fail((String)("Expected exception on size over the limit, but got: " + changeSets));
        }
        catch (ChangeSetContentTooLargeException e) {
            Assert.assertThat((String)"current limit should be reported", (Object)e.getFilePathLimit(), (Matcher)CoreMatchers.is((Object)5));
        }
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.never())).getChangeSet(org.mockito.Matchers.anyString());
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isAvailable();
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isChangesetCapable();
    }

    @Test
    public void testCreateChangeSetsNoSizeCheck() throws Exception {
        CrucibleChangeSet ccs123 = new CrucibleChangeSet("123", "123", null, null, null, null, null);
        CrucibleChangeSet ccs999 = new CrucibleChangeSet("999", "999", null, null, null, null, null);
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someRepo", (String)"123"));
        this.helper.addCrucibleChangeSet(ChangeSetPair.newInstance((String)"someOtherRepo", (String)"999"));
        Mockito.when((Object)this.effectiveUserProviderMock.getEffectivePrincipal()).thenReturn((Object)this.principalMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceFactoryMock.getSource("someOtherRepo", this.principalMock)).thenReturn((Object)this.sourceMock);
        Mockito.when((Object)this.sourceMock.isAvailable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.isChangesetCapable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("123")).thenReturn((Object)3);
        Mockito.when((Object)this.sourceMock.getChangeSetRevisionCount("999")).thenReturn((Object)4);
        Mockito.when((Object)this.sourceMock.getChangeSet("123", true)).thenReturn((Object)ccs123);
        Mockito.when((Object)this.sourceMock.getChangeSet("999", true)).thenReturn((Object)ccs999);
        List changeSets = this.helper.createChangeSetsNoSizeCheck(true);
        Assert.assertThat((Object)changeSets, (Matcher)Matchers.hasItems((Object[])new CrucibleChangeSet[]{ccs123, ccs999}));
        Assert.assertThat((String)"exactly 2 crucible changesets retrieved", (Object)changeSets.size(), (Matcher)CoreMatchers.is((Object)2));
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isAvailable();
        ((Source)Mockito.verify((Object)this.sourceMock, (VerificationMode)Mockito.times((int)2))).isChangesetCapable();
    }
}

