/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.atlassian.crucible.activity.review.LuceneReviewStateChangeActivityItemProvider;
import com.atlassian.crucible.activity.review.LuceneReviewViewableItems;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.hibernate.DbVersionManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import java.sql.SQLException;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReviewStateChangeActivityItemProviderTest
extends ActivityItemTestBase {
    private Review review1;
    private String review1Csid = "MAIN:matt:20041205010425";
    private Path pathUnderReview1 = new Path((CharSequence)"emptytests/notempty/a.txt");
    private Path notUnderReview = new Path((CharSequence)"test/CleanSweeper.java");
    private LuceneReviewStateChangeActivityItemProvider provider;

    @Override
    public void tearDown() throws Exception {
        this.currentUser = null;
        this.currentUserLogin = null;
        this.cvsSource = null;
        this.review1 = null;
        this.cvsHandle = null;
        super.tearDown();
    }

    @Test
    public void testReviewStateChangeActivityItemProvider() throws Exception {
        DbVersionManager dummyDbVersionManager = new DbVersionManager(){

            public Integer getDbVersionValue(int key) throws SQLException {
                return 1;
            }

            public void setDbVersionValue(int key, int value) throws SQLException {
            }

            public int getDbTimeStamp() throws SQLException {
                return 1;
            }
        };
        this.provider = new LuceneReviewStateChangeActivityItemProvider(this.reviewManager, (StateChangeLogManager)SpringContext.getComponentByClass(StateChangeLogManager.class), (LuceneReviewViewableItems)SpringContext.getComponentByClass(LuceneReviewViewableItems.class));
        HibernateUtil.beginTransaction();
        this.review1 = this.reviewManager.createReview(this.pm, this.pm.getDefaultProject(), "test review1", this.currentUser);
        this.review1.setModerator(this.currentUser);
        this.review1.setAuthor(this.currentUser);
        this.review1.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        ActivityItemSearchParams.Builder params = new ActivityItemSearchParams.Builder();
        params.maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(10).includeCrucible();
        ActivityItemList ail = this.provider.findActivityItems(params.build(), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)0L, (long)ail.getItems().size());
        params = new ActivityItemSearchParams.Builder();
        params.path("cvs", this.pathUnderReview1).maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(10).includeCrucible();
        ail = this.provider.findActivityItems(params.build(), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)0L, (long)ail.getItems().size());
        HibernateUtil.beginTransaction();
        ReviewCreationHelper cvsRch1 = new ReviewCreationHelper(this.cvsSource, this.review1, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        ReviewCreationTestHelper.addChangeSet(cvsRch1, this.cvsSource, this.currentUser, this.review1Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.reviewManager.changeState(this.review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        params = new ActivityItemSearchParams.Builder();
        params.maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(10).includeCrucible();
        ail = this.provider.findActivityItems(params.build(), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)1L, (long)ail.getItems().size());
        Assert.assertTrue((String)"not ReviewStateChangeActivityItem", (boolean)(ail.getItems().get(0) instanceof ReviewStateChangeActivityItem));
        ReviewStateChangeActivityItem rscai = (ReviewStateChangeActivityItem)ail.getItems().get(0);
        Assert.assertEquals((Object)this.currentUser, (Object)rscai.getUser());
        Assert.assertEquals((String)"wrong state type", (Object)StateManager.States.REVIEW_STATE, (Object)rscai.getStateType());
        Assert.assertEquals((String)"wrong project key", (Object)(this.pm.getDefaultProject().getkey() + "-1"), (Object)rscai.getReviewPermaId());
        params = new ActivityItemSearchParams.Builder();
        params.path("cvs", this.pathUnderReview1).maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(10).includeCrucible();
        ail = this.provider.findActivityItems(params.build(), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)1L, (long)ail.getItems().size());
        Assert.assertTrue((String)"not ReviewStateChangeActivityItem", (boolean)(ail.getItems().get(0) instanceof ReviewStateChangeActivityItem));
        rscai = (ReviewStateChangeActivityItem)ail.getItems().get(0);
        Assert.assertEquals((Object)this.currentUser, (Object)rscai.getUser());
        Assert.assertEquals((String)"wrong state type", (Object)StateManager.States.REVIEW_STATE, (Object)rscai.getStateType());
        Assert.assertEquals((String)"wrong project key", (Object)(this.pm.getDefaultProject().getkey() + "-1"), (Object)rscai.getReviewPermaId());
        params = new ActivityItemSearchParams.Builder();
        params.path("cvs", this.notUnderReview).maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(10).includeCrucible();
        ail = this.provider.findActivityItems(params.build(), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)0L, (long)ail.getItems().size());
    }
}

