/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.atlassian.crucible.activity.review.ProjectConstraint;
import com.atlassian.crucible.activity.review.ProjectConstraintBuilder;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.CommentStar;
import com.atlassian.fisheye.stars.model.ProjectStar;
import com.atlassian.fisheye.stars.model.ReviewStar;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ProjectConstraintBuilderTest
extends ActivityItemTestBase {
    private Review review1;
    private Review review2;
    private Review review3;
    private Review review4;
    private String review1Csid = "MAIN:matt:20041205010425";
    private String review2Csid = "MAIN:matt:20050113032653";
    private Project project;
    private Project project2;
    private Comment comment1;
    private Comment comment2;
    private Comment comment3;
    private Comment comment4;
    private List<Star> stars;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stars = new ArrayList<Star>();
        this.project = this.pm.createProject("Project1", "PR1");
        this.project2 = this.pm.createProject("Project2", "PR2");
        HibernateUtil.beginTransaction();
        this.review1 = this.reviewManager.createReview(this.pm, this.project, "test review1", this.reviewer);
        this.review1.setModerator(this.currentUser);
        this.review1.setAuthor(this.currentUser);
        this.review1.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch1 = new ReviewCreationHelper(this.cvsSource, this.review1, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        this.review2 = this.reviewManager.createReview(this.pm, this.project, "test review2", this.reviewer);
        this.review2.setModerator(this.currentUser);
        this.review2.setAuthor(this.currentUser);
        this.review2.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch2 = new ReviewCreationHelper(this.cvsSource, this.review2, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        this.review3 = this.reviewManager.createReview(this.pm, this.project2, "test review1", this.reviewer);
        this.review3.setModerator(this.currentUser);
        this.review3.setAuthor(this.currentUser);
        this.review3.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.review4 = this.reviewManager.createReview(this.pm, this.project2, "test review1", this.reviewer);
        this.review4.setModerator(this.currentUser);
        this.review4.setAuthor(this.currentUser);
        this.review4.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch1, this.cvsSource, this.currentUser, this.review1Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment1 = this.commentManager.createComment("comment1 on " + this.review1Csid, this.review1, this.currentUser);
        this.reviewManager.changeState(this.review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch2, this.cvsSource, this.currentUser, this.review2Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment2 = this.commentManager.createComment("comment2 on " + this.review2Csid, this.review2, this.currentUser);
        this.reviewManager.changeState(this.review2, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.comment3 = this.commentManager.createComment("comment3", this.review3, this.currentUser);
        this.reviewManager.changeState(this.review3, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.comment4 = this.commentManager.createComment("comment4", this.review4, this.currentUser);
        this.reviewManager.changeState(this.review4, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
    }

    @Override
    public void tearDown() throws Exception {
        this.stars = null;
        this.currentUser = null;
        this.currentUserLogin = null;
        this.cvsSource = null;
        this.review1 = null;
        this.review2 = null;
        this.review3 = null;
        this.review4 = null;
        this.comment1 = null;
        this.comment2 = null;
        this.comment3 = null;
        this.comment4 = null;
        this.project = null;
        this.project2 = null;
        this.cvsHandle = null;
        super.tearDown();
    }

    @Test
    public void testProjectConstraintBuilder() throws Exception {
        this.stars.add((Star)new ReviewStar(this.makeStarKey(StarType.REVIEW, this.review1.getId()), this.currentUser.getUsername()));
        ProjectConstraintBuilder builder = new ProjectConstraintBuilder(this.reviewManager, this.commentManager);
        ProjectConstraint params = builder.getActivityItemParams();
        Assert.assertTrue((boolean)params.getProjectIds().isEmpty());
        builder.addStars(this.stars);
        params = builder.getActivityItemParams();
        Assert.assertEquals((long)1L, (long)params.getProjectIds().size());
        int projectId = (Integer)params.getProjectIds().iterator().next();
        Assert.assertEquals((long)this.project.getId().intValue(), (long)projectId);
        ProjectConstraint.ProjectConstraintItem constraints = params.getConstraintsForProject(projectId);
        Assert.assertFalse((boolean)constraints.isWholeProject());
        Assert.assertTrue((boolean)constraints.getComments().isEmpty());
        Assert.assertEquals((long)1L, (long)constraints.getReviews().size());
        Assert.assertEquals((Object)this.review1.getId(), (Object)constraints.getReviews().iterator().next());
        this.stars.add((Star)new ReviewStar(this.makeStarKey(StarType.REVIEW, this.review3.getId()), this.currentUser.getUsername()));
        this.stars.add((Star)new CommentStar(this.makeStarKey(StarType.COMMENT, this.comment1.getId()), this.currentUser.getUsername()));
        this.stars.add((Star)new CommentStar(this.makeStarKey(StarType.COMMENT, this.comment2.getId()), this.currentUser.getUsername()));
        this.stars.add((Star)new CommentStar(this.makeStarKey(StarType.COMMENT, this.comment3.getId()), this.currentUser.getUsername()));
        this.stars.add((Star)new CommentStar(this.makeStarKey(StarType.COMMENT, this.comment4.getId()), this.currentUser.getUsername()));
        this.stars.add((Star)new ProjectStar(this.makeStarKey(StarType.PROJECT, this.project2.getId()), this.currentUser.getUsername()));
        builder.addStars(this.stars);
        params = builder.getActivityItemParams();
        Assert.assertEquals((long)2L, (long)params.getProjectIds().size());
        constraints = params.getConstraintsForProject(this.project.getId().intValue());
        Assert.assertFalse((boolean)constraints.isWholeProject());
        Assert.assertEquals((long)1L, (long)constraints.getReviews().size());
        Assert.assertEquals((long)1L, (long)constraints.getComments().size());
        Assert.assertEquals((Object)this.review1.getId(), (Object)constraints.getReviews().iterator().next());
        Assert.assertEquals((Object)this.comment2, constraints.getComments().iterator().next());
        constraints = params.getConstraintsForProject(this.project2.getId().intValue());
        Assert.assertTrue((boolean)constraints.isWholeProject());
        Assert.assertTrue((boolean)constraints.getComments().isEmpty());
        Assert.assertEquals((long)0L, (long)constraints.getReviews().size());
    }

    private StarKey makeStarKey(StarType type, int intKey1) {
        StarKey starKey = new StarKey(type.getName());
        starKey.setIntKey1(Integer.valueOf(intKey1));
        return starKey;
    }
}

