/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.review;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.PermissionManagerTestUtil;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import javax.servlet.ServletRequest;
import org.junit.After;
import org.junit.Before;

public abstract class ActivityItemTestBase {
    protected ProjectManager pm;
    protected FecruUser currentUser;
    protected UserLogin reviewerUserLogin;
    protected UserLogin currentUserLogin;
    protected Source cvsSource;
    protected ContentManager contentManager;
    protected SourceFactory sourceFactory;
    protected RepositoryHandle cvsHandle;
    protected FecruUser creator;
    protected FecruUser reviewer;
    protected ReviewManager reviewManager;
    protected UserManager userManager;
    protected GroupMembershipManager groupMembershipManager;
    protected SPIUtils spiUtils;
    protected EffectiveUserProviderImpl effectiveUserProvider;
    protected CommentManager commentManager;
    protected EventPublisher eventPublisher;
    protected UserPermissionsTestRule userPermissionsTestRule;

    @Before
    public void setUp() throws Exception {
        ReviewUtil.resetEffectiveUserProvider();
        TestFishEyeInstances.checkCleanStart();
        TestFishEyeInstances.deleteData0();
        Disposer.pushThreadInstance();
        this.cvsHandle = TestFishEyeInstances.getSanity1Repos();
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
        this.reviewManager = (ReviewManager)SpringContext.getComponentByClass(ReviewManager.class);
        this.spiUtils = (SPIUtils)SpringContext.getComponentByClass(SPIUtils.class);
        this.contentManager = (ContentManager)SpringContext.getComponentByClass(ContentManager.class);
        this.effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponent((String)"effectiveUserProvider");
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.userManager.addGroup("team-1");
        this.groupMembershipManager = (GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class);
        this.userPermissionsTestRule.addFecruUser("reviewer", "reviewer", "reviewer@email.com");
        this.reviewer = ModelUtils.makeAndSaveUser("reviewer");
        this.reviewerUserLogin = this.createTrustedUserLogin("reviewer");
        this.eventPublisher = (EventPublisher)SpringContext.getComponentByClass(EventPublisher.class);
        this.userPermissionsTestRule.addFecruUser("creator", "creator", "creator@email.com");
        this.currentUser = this.creator = ModelUtils.makeAndSaveUser("creator");
        this.currentUserLogin = this.createTrustedUserLogin("creator");
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)this.currentUserLogin, this.currentUser);
        CrucibleFilter.setContext((CrucibleFilter.Context)new CrucibleFilter.Context((ServletRequest)new DummyHttpServletRequest(), null));
        this.sourceFactory = (SourceFactory)SpringContext.getComponentByClass(SourceFactory.class);
        this.cvsSource = this.sourceFactory.getSource(this.cvsHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUserLogin);
        this.pm = ModelUtils.getProjectManager();
        this.commentManager = ModelUtils.getCommentManager();
        HibernateUtil.beginTransaction();
        PermissionManagerTestUtil.checkAndCreateDefaultPS((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class));
        HibernateUtil.commitTransaction();
    }

    @After
    public void tearDown() throws Exception {
        this.userPermissionsTestRule.after();
        ReviewUtil.resetEffectiveUserProvider();
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        this.effectiveUserProvider.popEffectivePrincipal();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
        CrucibleFilter.setContext(null);
    }

    protected UserLogin createTrustedUserLogin(String username) throws DbException, LicensePolicyException {
        UserLogin ul = this.userManager.createTrustedUserLogin(username);
        this.groupMembershipManager.addUserToGroup("team-1", ul.getUsername());
        return ul;
    }
}

