/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.lucene;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.Visitor;
import com.cenqua.crucible.hibernate.DbVersionManager;
import com.cenqua.crucible.hibernate.ReviewItemIndexListener;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.ReviewDiscussionBrowser;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.StateChangeLogManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DefaultReviewItemIndexerTestFixture {
    private final File indexBaseDir;
    private final ProjectManager projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
    private final DbVersionManager dbVersionManager = (DbVersionManager)Mockito.mock(DbVersionManager.class);
    private final ReviewManager reviewManager = (ReviewManager)Mockito.mock(ReviewManager.class);
    private final SecureProjectManager secureProjectManager = (SecureProjectManager)Mockito.mock(SecureProjectManager.class);
    private EffectiveUserProvider effectiveUserProvider = (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class);
    private final Principal effectivePrincipal = (Principal)Mockito.mock(Principal.class);
    private final PermissionManager permissionManager = (PermissionManager)Mockito.mock(PermissionManager.class);
    private final LogItemManager logItemManager = (LogItemManager)Mockito.mock(LogItemManager.class);
    private final StateChangeLogManager stateChangeLogManager = (StateChangeLogManager)Mockito.mock(StateChangeLogManager.class);
    private final UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
    private final List<Review> reviews = Lists.newArrayList();
    private final List<LogItem> logItems = Lists.newArrayList();
    private DefaultReviewItemIndexer indexer;
    private boolean started;

    public DefaultReviewItemIndexerTestFixture() {
        this(FisheyeTestUtil.getTmpDir());
    }

    public DefaultReviewItemIndexerTestFixture(File dir) {
        this.indexBaseDir = new File(dir, "cruidx");
        Mockito.when((Object)this.effectivePrincipal.getUserName()).thenReturn((Object)"no-one");
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)this.effectivePrincipal);
        Mockito.when((Object)this.userManager.getUserById(Matchers.anyInt())).thenAnswer(invocation -> {
            Integer userId = (Integer)invocation.getArguments()[0];
            return new FecruUser(userId, String.valueOf(userId));
        });
    }

    public Project addProject(int id, String key) {
        this.guardNotStarted();
        Project project = new Project();
        project.setId(Integer.valueOf(id));
        project.setProjKey(key);
        Mockito.when((Object)this.projectManager.getProjectById(id)).thenReturn((Object)project);
        return project;
    }

    public Review addReview(Project project, int reviewId, String author, String moderator, String name, String description, String summary, String linkedIssue, String state, Date dueDate, String ... reviewers) {
        this.guardNotStarted();
        Review review = this.mockReview(project, reviewId, author, moderator, name, description, summary, linkedIssue, state, dueDate, reviewers, null, null);
        this.reviews.add(review);
        return review;
    }

    public Review addReview(Project project, int reviewId, String author, String moderator, String name, String description, String summary, String linkedIssue, String state, Date dueDate, String[] reviewers, boolean[] completed, String creator) {
        this.guardNotStarted();
        Review review = this.mockReview(project, reviewId, author, moderator, name, description, summary, linkedIssue, state, dueDate, reviewers, completed, creator);
        this.reviews.add(review);
        return review;
    }

    public Review addReview(Project project, int reviewId, ReviewData.State state) {
        return this.addReview(project, reviewId, "author" + reviewId, "moderator" + reviewId, "name" + reviewId, "desc" + reviewId, "summary" + reviewId, null, state.name(), new Date(), new String[0]);
    }

    public LogItem addLogItem(LogItem logItem) {
        this.logItems.add(logItem);
        return logItem;
    }

    public void setEffectiveUser(String user) {
        Mockito.when((Object)this.effectivePrincipal.getUserName()).thenReturn((Object)user);
    }

    private void guardNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Fixture is already started.");
        }
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    protected Review transformReview(Review review) {
        return review;
    }

    protected Iterable<Review> transformReviews(Iterable<Review> reviews) {
        return reviews;
    }

    public DefaultReviewItemIndexer start() throws IOException {
        return this.start(true);
    }

    public DefaultReviewItemIndexer start(boolean index) throws IOException {
        this.guardNotStarted();
        this.started = true;
        CommentManager commentManager = (CommentManager)Mockito.mock(CommentManager.class);
        ReviewDiscussionBrowser reviewDiscussionBrowser = (ReviewDiscussionBrowser)Mockito.mock(ReviewDiscussionBrowser.class);
        Mockito.when((Object)reviewDiscussionBrowser.count()).thenReturn((Object)10);
        Mockito.when((Object)commentManager.comments((Review)Matchers.any(Review.class))).thenReturn((Object)reviewDiscussionBrowser);
        Mockito.when((Object)commentManager.comments((Review)Matchers.any(Review.class)).where((DiscussionClause)Matchers.any(DiscussionClause.class))).thenReturn((Object)reviewDiscussionBrowser);
        this.indexer = new DefaultReviewItemIndexer(this.dbVersionManager, this.indexBaseDir, this.secureProjectManager, commentManager, this.effectiveUserProvider, this.permissionManager, (ParticipantDAO)Mockito.mock(ParticipantDAO.class), this.logItemManager, this.stateChangeLogManager, this.userManager);
        this.indexer.setReviewManager(this.reviewManager);
        this.indexer.start(false);
        ((ReviewManager)Mockito.doAnswer(invocation -> {
            Visitor visitor = (Visitor)invocation.getArguments()[0];
            for (Review review : this.transformReviews(this.reviews)) {
                visitor.visit((Object)review);
            }
            return null;
        }).when((Object)this.reviewManager)).visitAllReviews((Visitor)Matchers.any(Visitor.class));
        for (Review review : this.reviews) {
            Mockito.when((Object)this.reviewManager.getReviewById(review.getId())).thenAnswer(invocation -> this.transformReview(review));
        }
        if (index) {
            ReviewItemIndexListener.Changes changes = new ReviewItemIndexListener.Changes();
            ReviewItemIndexListener.ReviewChanges reviewChanges = new ReviewItemIndexListener.ReviewChanges();
            reviewChanges.setReviewChanged(false);
            reviewChanges.setLastModified(Long.valueOf(System.currentTimeMillis()));
            for (Review review : this.reviews) {
                changes.getChangesForReviews().put((Object)review.getId(), (Object)reviewChanges);
            }
            Mockito.when((Object)this.logItemManager.getLogItemById(Integer.valueOf(Matchers.anyInt()))).thenAnswer(invocationOnMock -> {
                Integer logItemId = (Integer)invocationOnMock.getArguments()[0];
                return Iterables.getFirst((Iterable)Iterables.filter(this.logItems, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)logItemId), (Function)LogItem.TO_ID)), null);
            });
            reviewChanges.getLogItemIds().addAll(Collections2.transform(this.logItems, (Function)LogItem.TO_ID));
            this.indexer.index(changes);
        }
        return this.indexer;
    }

    public Principal getEffectivePrincipal() {
        return this.effectivePrincipal;
    }

    public void stop() throws Exception {
        try {
            if (this.indexer != null) {
                this.indexer.stop();
            }
        }
        finally {
            FileUtils.deleteTree((File)this.indexBaseDir);
        }
    }

    private Review mockReview(Project project, int id, String author, String moderator, String name, String description, String summary, String linkedIssue, String state, Date dueDate, String[] reviewers, final boolean[] completed, String creator) {
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getId()).thenReturn((Object)id);
        Mockito.when((Object)review.getSummary()).thenReturn((Object)summary);
        Mockito.when((Object)review.getJiraIssueKey()).thenReturn((Object)linkedIssue);
        FecruUser crucibleUser = new FecruUser(author);
        Mockito.when((Object)review.getAuthor()).thenReturn((Object)crucibleUser);
        Mockito.when((Object)review.getCreator()).thenReturn((Object)new FecruUser(creator == null ? author : creator));
        Mockito.when((Object)review.getDescription()).thenReturn((Object)description);
        Mockito.when((Object)review.getName()).thenReturn((Object)name);
        Mockito.when((Object)review.getType()).thenReturn((Object)Review.ReviewType.REVIEW);
        Mockito.when((Object)review.getProject()).thenReturn((Object)project);
        Mockito.when((Object)review.getState()).thenReturn((Object)StateManager.INSTANCE.getStateByName(state));
        Mockito.when((Object)review.getStateName()).thenReturn((Object)state);
        Mockito.when((Object)review.getDueDate()).thenReturn((Object)dueDate);
        Mockito.when((Object)this.projectManager.getNextPermaId(project, review)).thenReturn((Object)new ReviewPermaId(review, project.getProjKey(), id));
        Mockito.when((Object)review.isModerated()).thenReturn((Object)(moderator != null ? 1 : 0));
        ImmutableSet.Builder participants = new ImmutableSet.Builder();
        ReviewParticipant authorParticipant = new ReviewParticipant();
        authorParticipant.setUser(crucibleUser);
        authorParticipant.setAuthor(true);
        authorParticipant.setId(Integer.valueOf(1));
        participants.add((Object)authorParticipant);
        if (!Strings.isNullOrEmpty((String)moderator)) {
            ReviewParticipant moderatorParticipant = new ReviewParticipant();
            moderatorParticipant.setUser(new FecruUser(moderator));
            moderatorParticipant.setModerator(true);
            moderatorParticipant.setId(Integer.valueOf(2));
            Mockito.when((Object)review.getModerator()).thenReturn((Object)moderatorParticipant.getUser());
            participants.add((Object)moderatorParticipant);
        }
        final MutableBoolean allReviewersComplete = new MutableBoolean(true);
        ImmutableList reviewerParticipants = ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(reviewers), (Function)new Function<String, ReviewParticipant>(){
            int i = 1000;

            public ReviewParticipant apply(String input) {
                boolean reviewerCompleted;
                ReviewParticipant reviewParticipant = (ReviewParticipant)Mockito.mock(ReviewParticipant.class);
                Mockito.when((Object)reviewParticipant.isReviewer()).thenReturn((Object)true);
                Mockito.when((Object)reviewParticipant.getUser()).thenReturn((Object)new FecruUser(input));
                boolean bl = completed == null ? this.i % 2 == 0 : (reviewerCompleted = completed[this.i - 1000]);
                if (!reviewerCompleted) {
                    allReviewersComplete.setValue(false);
                }
                Mockito.when((Object)reviewParticipant.isAllComplete()).thenReturn((Object)reviewerCompleted);
                Mockito.when((Object)reviewParticipant.getId()).thenReturn((Object)this.i++);
                return reviewParticipant;
            }
        }));
        participants.addAll((Iterable)reviewerParticipants);
        ImmutableSet allParticipants = participants.build();
        Mockito.when((Object)review.getParticipants()).thenReturn((Object)allParticipants);
        Mockito.when((Object)review.getReviewerParticipants()).thenReturn((Object)ImmutableSet.copyOf((Collection)reviewerParticipants));
        Mockito.when((Object)review.getPermaId()).thenReturn((Object)(project.getProjKey() + "-" + id));
        Mockito.when((Object)review.getPermaIdHistory()).thenReturn((Object)ImmutableSet.of((Object)new ReviewPermaId(null, project.getProjKey(), id)));
        Mockito.when((Object)review.getStateSetDate()).thenReturn((Object)new Date());
        Mockito.when((Object)review.isAllReviewersComplete()).thenReturn((Object)allReviewersComplete.booleanValue());
        return review;
    }

    public void addRolePermission(Role role, String action, Set<Integer> projectIds) {
        Mockito.when((Object)this.permissionManager.getProjectsRoleCanDoActionIn(role, action)).thenReturn(projectIds);
    }

    public SecureProjectManager getSecureProjectManager() {
        return this.secureProjectManager;
    }

    public void setEffectiveUserProvider(EffectiveUserProvider effectiveUserProvider) {
        this.effectiveUserProvider = effectiveUserProvider;
    }
}

