/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity.lucene;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexerTestFixture;
import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.wikirenderer.DummyCrucibleWikiRenderer;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.reviews.ReviewDetailsSearcher;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogItemBuilder;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.DummyLinkerService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultReviewItemIndexerTest {
    private DefaultReviewItemIndexerTestFixture fixture = new DefaultReviewItemIndexerTestFixture();

    @After
    public void tearDown() throws Exception {
        this.fixture.stop();
    }

    @Test
    public void testInterruptedForceReindex() throws Exception {
        final AtomicBoolean crashIndexer = new AtomicBoolean(false);
        DefaultReviewItemIndexerTestFixture fixture = new DefaultReviewItemIndexerTestFixture(){

            @Override
            protected Iterable<Review> transformReviews(Iterable<Review> reviews) {
                try {
                    if (crashIndexer.get()) {
                        throw new RuntimeException("Expected Exception: crashing the indexer");
                    }
                    return super.transformReviews(reviews);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        DefaultReviewItemIndexer indexer = fixture.start();
        crashIndexer.set(true);
        Assert.assertFalse((boolean)((Boolean)indexer.forceIndexRebuild().get()));
        crashIndexer.set(false);
        Assert.assertTrue((boolean)((Boolean)indexer.forceIndexRebuild().get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexEnd2End() throws Exception {
        Project projectTen = this.fixture.addProject(10, "PRJ10-KEY");
        Project projectEleven = this.fixture.addProject(11, "PRJ11-KEY");
        Project projectTwelve = this.fixture.addProject(12, "PRJ12-KEY");
        Review review = this.fixture.addReview(projectTen, 1, "npellow", "npellow", "JRA-123: the name of my review!", "mycsid: A review description", "A review summary. JRA-123. CR-JRA-456.", "JRA-123", "Review", new Date(), new String[0]);
        this.fixture.addReview(projectEleven, 2, "mquail", "mquail", "JRA-123: the name of my review!", "mycsid: review description", "A review summary. JRA-123. CR-JRA-789.", "JRA-123", "Review", new Date(), new String[0]);
        this.fixture.addReview(projectTwelve, 3, "mquail", "brendan", "No review for you!", "Redacted redacted redacted", "", null, "Review", new Date(), new String[0]);
        this.fixture.addRolePermission(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW, Sets.newHashSet((Object[])new Integer[]{10, 11, 12}));
        this.fixture.addRolePermission(ReviewManager.REVIEWER, UserActionManager.ACTION_VIEW, Sets.newHashSet((Object[])new Integer[]{10, 11, 12}));
        this.fixture.addRolePermission(ReviewManager.MODERATOR, UserActionManager.ACTION_VIEW, Sets.newHashSet((Object[])new Integer[]{12}));
        this.fixture.addRolePermission(ReviewManager.CREATOR, UserActionManager.ACTION_VIEW, Sets.newHashSet((Object[])new Integer[]{10, 11, 12}));
        final HashSet projectsAllUsersCanSee = Sets.newHashSet((Object[])new Integer[]{10, 11});
        RootConfig originalConfig = AppConfig.getsConfig();
        final DefaultReviewItemIndexer indexer = this.fixture.start();
        try {
            AppConfig.resetConfig((RootConfig)DummyCrucibleWikiRenderer.getMockConfig());
            ReviewDetailsSearcher searcher = new ReviewDetailsSearcher((WikiRenderer)new DummyCrucibleWikiRenderer(), new DummyLinkerService(), this.fixture.getProjectManager()){

                protected Query generateQuery(String userQuery, SearchScope scope) {
                    BooleanQuery query = indexer.queryForReviewDetailsWithoutSecurity(userQuery, scope);
                    Query securityQ = indexer.queryForSecurityConstraint(DefaultReviewItemIndexerTest.this.fixture.getEffectivePrincipal(), projectsAllUsersCanSee);
                    query.add(securityQ, BooleanClause.Occur.MUST);
                    return query;
                }
            };
            searcher.setReviewItemIndexer((ReviewItemIndexer)indexer);
            SearchScope scope = SearchScope.builder().build();
            searcher.search("JRA-123", scope).getIterator();
            Assert.assertEquals((long)2L, (long)searcher.search("JRA-123", scope).getTotalCount());
            Assert.assertEquals((long)2L, (long)searcher.search("JRA", scope).getTotalCount());
            Assert.assertEquals((long)1L, (long)searcher.search(review.getAuthor().getUsername(), scope).getTotalCount());
            Assert.assertEquals((long)1L, (long)searcher.search("mq", scope).getTotalCount());
            SearchResults byDescription = searcher.search("A review description", scope);
            Assert.assertEquals((long)2L, (long)byDescription.getTotalCount());
            Assert.assertEquals((long)2L, (long)searcher.search("mycsid", scope).getTotalCount());
            Assert.assertEquals((long)2L, (long)searcher.search("mycsid:", scope).getTotalCount());
            Assert.assertEquals((long)1L, (long)searcher.search("CR-JRA-789", scope).getTotalCount());
            Assert.assertEquals((long)2L, (long)searcher.search("CR-JRA", scope).getTotalCount());
            Assert.assertEquals((long)0L, (long)searcher.search("Redacted", scope).getTotalCount());
            this.fixture.setEffectiveUser("mquail");
            Assert.assertEquals((long)1L, (long)searcher.search("Redacted", scope).getTotalCount());
            Assert.assertEquals((long)1L, (long)searcher.search("CR-JRA-456", scope).getTotalCount());
            this.fixture.setEffectiveUser("brendan");
            Assert.assertEquals((long)1L, (long)searcher.search("Redacted", scope).getTotalCount());
        }
        finally {
            AppConfig.resetConfig((RootConfig)originalConfig);
        }
    }

    @Test
    public void testQueryForSecurityConstraint() throws Exception {
        DefaultReviewItemIndexer indexer = this.fixture.start();
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getUserName()).thenReturn((Object)"npellow");
        HashSet<Integer> projects = new HashSet<Integer>(){
            {
                this.add(10);
                this.add(11);
            }
        };
        this.fixture.addRolePermission(ReviewManager.AUTHOR, UserActionManager.ACTION_VIEW, (Set<Integer>)projects);
        this.fixture.addRolePermission(ReviewManager.REVIEWER, UserActionManager.ACTION_VIEW, (Set<Integer>)projects);
        this.fixture.addRolePermission(ReviewManager.MODERATOR, UserActionManager.ACTION_VIEW, (Set<Integer>)projects);
        this.fixture.addRolePermission(ReviewManager.CREATOR, UserActionManager.ACTION_VIEW, (Set<Integer>)projects);
        BooleanQuery q = (BooleanQuery)indexer.queryForSecurityConstraint(principal, (Set)projects);
        Assert.assertEquals((long)1L, (long)q.getClauses().length);
        Assert.assertEquals((Object)BooleanClause.Occur.SHOULD, (Object)q.getClauses()[0].getOccur());
    }

    @Test
    public void testSortReviewsByName() throws Exception {
        Project p = this.fixture.addProject(1, "CR");
        this.addReview(this.fixture, p, "something goes here", 1);
        this.addReview(this.fixture, p, "STRINGS ONLY HERE", 2);
        this.addReview(this.fixture, p, "change after branch", 3);
        this.addReview(this.fixture, p, "ABC things here", 4);
        DefaultReviewItemIndexer indexer = this.fixture.start();
        DefaultReviewManager reviewManager = new DefaultReviewManager(null, null, null, null, null, null, null, null, null, null, null, null, (TxTemplate)new DummyTxTemplate());
        reviewManager.setReviewItemIndexer((ReviewItemIndexer)indexer);
        List sortedReviews = reviewManager.getMatchingReviewIds(new ReviewFilterDef(ReviewFilters.FilterKey.ALL_REVIEWS), "", ReviewSort.NAME);
        Assert.assertThat((Object)sortedReviews, (Matcher)Matchers.contains((Object[])new Integer[]{4, 3, 1, 2}));
    }

    @Test
    public void testIndexLogItemWithNullUserId() throws Exception {
        Project project = this.fixture.addProject(1, "CR");
        Review review = this.addReview(this.fixture, project, "something goes here", 1);
        FRXRevision frxRevision = this.mockFrxRevision(10, 11, "/some/path", "12345abc");
        LogItem logItem = this.fixture.addLogItem(LogItemBuilder.from((LogItem)LogItemBuilder.buildReviewRevisionAdded((Review)review, null, (FRXRevision)frxRevision)).id(Integer.valueOf(1)).build());
        DefaultReviewItemIndexer indexer = this.fixture.start();
        Term logItemTerm = new Term("reviewerJoinId", logItem.getId().toString());
        Assert.assertThat((Object)indexer.countHits((Query)new TermQuery(logItemTerm)), (Matcher)Matchers.is((Object)1));
    }

    private Review addReview(DefaultReviewItemIndexerTestFixture fixture, Project p, String title, int id) {
        return fixture.addReview(p, id, "npellow", "npellow", title, "mycsid: A review description", "A review summary. JRA-123. CR-JRA-456.", "JRA-123", "Review", new Date(), new String[0]);
    }

    private FRXRevision mockFrxRevision(int frxRevisionId, int frxId, String path, String revision) {
        FileRevisionExtraInfo frx = (FileRevisionExtraInfo)Mockito.mock(FileRevisionExtraInfo.class);
        Mockito.when((Object)frx.getId()).thenReturn((Object)frxId);
        CrucibleRevision crucibleRevision = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        Mockito.when((Object)crucibleRevision.getPath()).thenReturn((Object)path);
        Mockito.when((Object)crucibleRevision.getRevision()).thenReturn((Object)revision);
        FRXRevision frxRevision = (FRXRevision)Mockito.mock(FRXRevision.class);
        Mockito.when((Object)frxRevision.getId()).thenReturn((Object)frxRevisionId);
        Mockito.when((Object)frxRevision.getFrx()).thenReturn((Object)frx);
        Mockito.when((Object)frxRevision.getRevision()).thenReturn((Object)crucibleRevision);
        return frxRevision;
    }

    @Test
    public void testSortReviewsByKey() throws Exception {
        Project projectB = this.fixture.addProject(1, "B");
        Project projectA = this.fixture.addProject(2, "A");
        this.addReview(this.fixture, projectB, "Project B Test 1.", 1);
        this.addReview(this.fixture, projectA, "Project A Test 2", 2);
        this.addReview(this.fixture, projectB, "Project B Test 3", 3);
        this.addReview(this.fixture, projectA, "Project A Test 4", 4);
        this.addReview(this.fixture, projectB, "Project B Test 10", 10);
        this.addReview(this.fixture, projectA, "Project A Test 11", 11);
        DefaultReviewItemIndexer indexer = this.fixture.start();
        DefaultReviewManager reviewManager = new DefaultReviewManager(null, null, null, null, null, null, null, null, null, null, null, null, (TxTemplate)new DummyTxTemplate());
        reviewManager.setReviewItemIndexer((ReviewItemIndexer)indexer);
        List sortedReviews = reviewManager.getMatchingReviewIds(new ReviewFilterDef(ReviewFilters.FilterKey.ALL_REVIEWS), "", ReviewSort.REVIEW);
        Assert.assertThat((Object)sortedReviews, (Matcher)Matchers.contains((Object[])new Integer[]{2, 4, 11, 1, 3, 10}));
    }
}

