/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.atlassian.crucible.activity.review.ReviewCommentActivityItem;
import com.atlassian.crucible.activity.review.ReviewCompletionActivityItem;
import com.atlassian.crucible.activity.review.ReviewStateChangeActivityItem;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.StarDownStreamActivityItemManager;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.ChangeSetHolder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StarDownStreamActivityItemManagerTest
extends ActivityItemTestBase {
    private StarManager starManager = null;
    private UserManager um;
    private UserLogin userLogin;
    private FecruUser starman;
    private FecruUser userA;
    private FecruUser userB;
    private List<Star> stars;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.starManager = (StarManager)SpringContext.getComponentByClass(StarManager.class);
        ReviewItemIndexer indexer = (ReviewItemIndexer)SpringContext.getComponentByClass(ReviewItemIndexer.class);
        indexer.forceIndexRebuild();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        HibernateUtil.beginTransaction();
        this.starman = this.userPermissionsTestRule.addFecruUser("starman");
        this.userA = this.userPermissionsTestRule.addFecruUser("matt");
        this.userB = this.userPermissionsTestRule.addFecruUser("brendan");
        this.userLogin = this.um.createTrustedUserLogin("starman");
        List starList = this.starManager.getStarsForUser(this.userLogin.getUsername());
        for (Star star : starList) {
            this.starManager.removeStar(star.getId().intValue());
        }
        HibernateUtil.commitTransaction();
        this.stars = new ArrayList<Star>();
        EventPublisher eventPublisher = (EventPublisher)SpringContext.getComponent((String)"eventPublisher");
        eventPublisher.unregisterAll();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        HibernateUtil.beginTransaction();
        List starList = this.starManager.getStarsForUser(this.userLogin.getUsername());
        for (Star star : starList) {
            this.starManager.removeStar(star.getId().intValue());
        }
        HibernateUtil.commitTransaction();
        this.um.deleteUserFully(this.userA.getUsername());
        this.um.deleteUserFully(this.userB.getUsername());
        this.um.deleteUserFully(this.starman.getUsername());
        HibernateUtil.closeSession();
        super.tearDown();
    }

    @Test
    public void testCruStarDownStreamActivity() throws Exception {
        String review1Csid = "MAIN:matt:20041205010425";
        String review2Csid = "MAIN:matt:20050113032653";
        HibernateUtil.beginTransaction();
        FecruUser r1 = this.userPermissionsTestRule.addFecruUser("r1");
        FecruUser r2 = this.userPermissionsTestRule.addFecruUser("r2");
        Project project = this.pm.createProject("Project1", "PR");
        Project project2 = this.pm.createProject("Project2", "PR2");
        Review review1 = this.reviewManager.createReview(this.pm, project, "test review1", this.currentUser);
        review1.setModerator(this.currentUser);
        review1.setAuthor(this.currentUser);
        review1.setCreator(this.currentUser);
        this.reviewManager.addReviewer(review1, r1);
        this.reviewManager.addReviewer(review1, r2);
        this.reviewManager.changeState(review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        ReviewCreationHelper cvsRch1 = new ReviewCreationHelper(this.cvsSource, review1, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch1, this.cvsSource, this.currentUser, review1Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        Comment comment1 = this.commentManager.createComment("comment1 on " + review1Csid, review1, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        Review review2 = this.reviewManager.createReview(this.pm, project, "test review2", this.currentUser);
        review2.setModerator(this.currentUser);
        review2.setAuthor(this.currentUser);
        review2.setCreator(this.currentUser);
        this.reviewManager.addReviewer(review2, r1);
        this.reviewManager.addReviewer(review2, r2);
        this.reviewManager.changeState(review2, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        ReviewCreationHelper cvsRch2 = new ReviewCreationHelper(this.cvsSource, review2, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        Review review3 = this.reviewManager.createReview(this.pm, project2, "test review3", this.currentUser);
        review3.setModerator(this.currentUser);
        review3.setAuthor(this.currentUser);
        review3.setCreator(this.currentUser);
        this.reviewManager.addReviewer(review3, r1);
        this.reviewManager.addReviewer(review3, r2);
        this.reviewManager.changeState(review3, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        Review review4 = this.reviewManager.createReview(this.pm, project2, "test review4", this.currentUser);
        review4.setModerator(this.currentUser);
        review4.setAuthor(this.currentUser);
        review4.setCreator(this.currentUser);
        this.reviewManager.addReviewer(review4, r1);
        this.reviewManager.addReviewer(review4, r2);
        this.reviewManager.changeState(review4, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch2, this.cvsSource, this.currentUser, review2Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        Comment comment2 = this.commentManager.createComment("comment2 on " + review2Csid, review2, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        Comment comment3 = this.commentManager.createComment("comment3", review3, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        Comment comment4 = this.commentManager.createComment("comment4", review4, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        review1.setReviewerComplete(r1);
        review1.setReviewerComplete(r2);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        review2.setReviewerComplete(r1);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        review3.setReviewerComplete(r2);
        HibernateUtil.commitTransaction();
        this.shortWait();
        HibernateUtil.beginTransaction();
        review4.setReviewerComplete(r1);
        review4.setReviewerComplete(r2);
        HibernateUtil.commitTransaction();
        this.stars.add(this.createIntStar(StarType.REVIEW, review1.getId()));
        this.stars.add(this.createIntStar(StarType.REVIEW, review3.getId()));
        this.stars.add(this.createIntStar(StarType.COMMENT, comment1.getId()));
        this.stars.add(this.createIntStar(StarType.COMMENT, comment2.getId()));
        this.stars.add(this.createIntStar(StarType.COMMENT, comment3.getId()));
        this.stars.add(this.createIntStar(StarType.COMMENT, comment4.getId()));
        this.stars.add(this.createIntStar(StarType.PROJECT, project2.getId()));
        Assert.assertEquals((long)this.stars.size(), (long)this.starManager.getStarsForUser(this.userLogin.getUsername()).size());
        StarDownStreamActivityItemManager itemManager = (StarDownStreamActivityItemManager)SpringContext.getComponentByClass(StarDownStreamActivityItemManager.class);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(30);
        builder.maxDate(new Date(System.currentTimeMillis()));
        builder.includeCrucible();
        ActivityItemList itemList = itemManager.findActivityItems(builder.build(), (Principal)this.userLogin, new ActivitySearchMonitor());
        List items = itemList.getItems();
        if (items.size() != 10) {
            for (ActivityItem ai : items) {
                System.out.println("+++ " + ai.getDate().getTime() + ":" + ai.getType() + ": " + ai.toString());
            }
        }
        Assert.assertEquals((long)10L, (long)items.size());
        ActivityItem item = (ActivityItem)items.get(9);
        Assert.assertEquals((Object)item.getType(), (Object)"review-stateChange");
        ReviewStateChangeActivityItem stateChangeActivityItem = (ReviewStateChangeActivityItem)item;
        Assert.assertEquals((Object)stateChangeActivityItem.getReviewPermaId(), (Object)review1.getPermaId());
        item = (ActivityItem)items.get(8);
        Assert.assertEquals((Object)"review-comment", (Object)item.getType());
        ReviewCommentActivityItem commentActivityItem = (ReviewCommentActivityItem)item;
        Assert.assertEquals((Object)comment1, (Object)commentActivityItem.getComment());
        item = (ActivityItem)items.get(7);
        Assert.assertEquals((Object)item.getType(), (Object)"review-stateChange");
        stateChangeActivityItem = (ReviewStateChangeActivityItem)item;
        Assert.assertEquals((Object)stateChangeActivityItem.getReviewPermaId(), (Object)review3.getPermaId());
        item = (ActivityItem)items.get(6);
        Assert.assertEquals((Object)item.getType(), (Object)"review-stateChange");
        stateChangeActivityItem = (ReviewStateChangeActivityItem)item;
        Assert.assertEquals((Object)stateChangeActivityItem.getReviewPermaId(), (Object)review4.getPermaId());
        item = (ActivityItem)items.get(5);
        Assert.assertEquals((Object)"review-comment", (Object)item.getType());
        commentActivityItem = (ReviewCommentActivityItem)item;
        Assert.assertEquals((Object)comment2, (Object)commentActivityItem.getComment());
        item = (ActivityItem)items.get(4);
        Assert.assertEquals((Object)"review-comment", (Object)item.getType());
        commentActivityItem = (ReviewCommentActivityItem)item;
        Assert.assertEquals((Object)comment3, (Object)commentActivityItem.getComment());
        item = (ActivityItem)items.get(3);
        Assert.assertEquals((Object)"review-comment", (Object)item.getType());
        commentActivityItem = (ReviewCommentActivityItem)item;
        Assert.assertEquals((Object)comment4, (Object)commentActivityItem.getComment());
        item = (ActivityItem)items.get(2);
        Assert.assertEquals((Object)"review-completion", (Object)item.getType());
        ReviewCompletionActivityItem completionActivityItem = (ReviewCompletionActivityItem)item;
        Assert.assertEquals((long)2L, (long)completionActivityItem.getParticipants().size());
        Assert.assertEquals((Object)review1, (Object)completionActivityItem.getReview());
        item = (ActivityItem)items.get(1);
        Assert.assertEquals((Object)"review-completion", (Object)item.getType());
        completionActivityItem = (ReviewCompletionActivityItem)item;
        Assert.assertEquals((long)1L, (long)completionActivityItem.getParticipants().size());
        Assert.assertEquals((Object)review3, (Object)completionActivityItem.getReview());
        item = (ActivityItem)items.get(0);
        Assert.assertEquals((Object)"review-completion", (Object)item.getType());
        completionActivityItem = (ReviewCompletionActivityItem)item;
        Assert.assertEquals((long)2L, (long)completionActivityItem.getParticipants().size());
        Assert.assertEquals((Object)review4, (Object)completionActivityItem.getReview());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivityStreamStarredDownstream() throws Exception {
        HibernateUtil.beginTransaction();
        FecruUser r1 = this.userPermissionsTestRule.addFecruUser("r1");
        FecruUser r2 = this.userPermissionsTestRule.addFecruUser("r2");
        Project project = this.pm.createProject("Project1", "PR");
        Review review1 = this.reviewManager.createReview(this.pm, project, "test review1", this.currentUser);
        review1.setModerator(this.currentUser);
        review1.setAuthor(this.currentUser);
        review1.setCreator(this.currentUser);
        this.reviewManager.addReviewer(review1, r1);
        this.reviewManager.addReviewer(review1, r2);
        this.reviewManager.changeState(review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.shortWait();
        UserLogin userAPrincipal = this.createTrustedUserLogin(this.userA.getUsername());
        try {
            this.effectiveUserProvider.pushEffectivePrincipal((Principal)userAPrincipal, this.userA);
            this.stars.add(this.createTwoStringStar(StarType.USER.getName(), this.userA.getUsername(), null, userAPrincipal));
            StarDownStreamActivityItemManager itemManager = (StarDownStreamActivityItemManager)SpringContext.getComponentByClass(StarDownStreamActivityItemManager.class);
            Assert.assertEquals((long)this.stars.size(), (long)this.starManager.getStarsForUser(this.userA.getUsername()).size());
            ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
            builder.searchDirection(SearchSortOrder.TOWARDS_PAST).timeZone(AppConfig.getUserTimeZone((String)this.userA.getUsername())).maxItems(30).maxDate(new Date(System.currentTimeMillis())).includeFisheye().includeCrucible().includeExternals().downstream();
            ActivityItemList items = itemManager.findActivityItems(builder.build(), (Principal)userAPrincipal, new ActivitySearchMonitor());
            Assert.assertEquals((String)"wrong number of activity items", (long)30L, (long)items.getItems().size());
            for (ActivityItem item : items.getItems()) {
                Assert.assertEquals((String)("Found a " + item.getType() + " item when there should only be " + "changeset" + " items"), (Object)"changeset", (Object)item.getType());
            }
        }
        finally {
            this.effectiveUserProvider.popEffectivePrincipal();
        }
    }

    @Test
    public void testFEStarDownStreamActivity() throws Exception {
        this.stars.add(this.createTwoStringStar("atlassian-user", "matt", null, this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-user", "brendan", null, this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-committer", "cvs", "anthony", this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-committer", "cvs2", "anthony", this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-committer", "cvs", "matt", this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-repository", "cvs2", null, this.userLogin));
        this.stars.add(this.createTwoStringStar("atlassian-directory", "test", "cvs", this.userLogin));
        Assert.assertEquals((long)this.stars.size(), (long)this.starManager.getStarsForUser(this.userLogin.getUsername()).size());
        StarDownStreamActivityItemManager itemManager = (StarDownStreamActivityItemManager)SpringContext.getComponentByClass(StarDownStreamActivityItemManager.class);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(30);
        builder.maxDate(new Date(System.currentTimeMillis()));
        builder.includeFisheye();
        ActivityItemList activityItemList = itemManager.findActivityItems(builder.build(), (Principal)this.userLogin, new ActivitySearchMonitor());
        List items = activityItemList.getItems();
        Assert.assertEquals((long)30L, (long)items.size());
        Iterator it = items.iterator();
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2_2:matt:20050517064053", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2:matt:20050323231241", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH1:matt:20050113032802", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032653", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032614", "cvs");
        this.removeStar(this.stars.get(0));
        this.removeStar(this.stars.get(6));
        this.removeStar(this.stars.get(4));
        builder = ActivityItemSearchParams.builder();
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxDate(new Date(System.currentTimeMillis()));
        builder.maxItems(10);
        builder.includeFisheye();
        activityItemList = itemManager.findActivityItems(builder.build(), (Principal)this.userLogin, new ActivitySearchMonitor());
        items = activityItemList.getItems();
        it = items.iterator();
        Assert.assertEquals((long)10L, (long)items.size());
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20041014145930", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20041012133813", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20041012105308", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20041011005813", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040927035147", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040927034003", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040924055317", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040924054708", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040723071526", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040526080128", "cvs");
        this.stars.add(this.createTwoStringStar("atlassian-directory", "test/test", "cvs", this.userLogin));
        this.removeStar(this.stars.get(1));
        builder = ActivityItemSearchParams.builder();
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.includeFisheye();
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 5, 1, 0, 0, 0);
        builder.maxDate(cal.getTime());
        builder.maxItems(6);
        activityItemList = itemManager.findActivityItems(builder.build(), (Principal)this.userLogin, new ActivitySearchMonitor());
        items = activityItemList.getItems();
        it = items.iterator();
        Assert.assertEquals((long)6L, (long)items.size());
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040526080128", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20040421023211", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "PROD_136:brendan:20031127062444", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "PROD_136:brendan:20031120042248", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:daniel:20031014014458", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:daniel:20030918062902", "cvs");
    }

    @Test
    public void testFileStarDownStream() throws Exception {
        this.stars.add(this.createTwoStringStar("atlassian-file", "CleanSweeper.java", "cvs2", this.userLogin));
        StarDownStreamActivityItemManager itemManager = (StarDownStreamActivityItemManager)SpringContext.getComponentByClass(StarDownStreamActivityItemManager.class);
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(5);
        builder.maxDate(new Date(System.currentTimeMillis()));
        builder.includeFisheye();
        ActivityItemList items = itemManager.findActivityItems(builder.build(), (Principal)this.userLogin, new ActivitySearchMonitor());
        Iterator it = items.getItems().iterator();
        this.assertChangeSet((ActivityItem)it.next(), "PROD_136:brendan:20031127062444", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "PROD_136:brendan:20031120042248", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:brendan:20030410072242", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030325235829", "cvs2");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:anthony:20030214044800", "cvs2");
    }

    private void assertChangeSet(ActivityItem holder, String csid, String repoName) {
        Assert.assertEquals((Object)csid, (Object)((ChangeSetHolder)holder).getChangeset().getId());
        Assert.assertEquals((Object)repoName, (Object)((ChangeSetHolder)holder).getContext().getRepoName());
    }

    private Star createTwoStringStar(String type, String stringKey1, String stringKey2, UserLogin u) throws Exception {
        HibernateUtil.beginTransaction();
        StarKey key = new StarKey(type);
        key.setStringKey1(stringKey1);
        key.setStringKey2(stringKey2);
        Star star = this.starManager.addStar(key, u);
        HibernateUtil.commitTransaction();
        return star;
    }

    private void removeStar(Star star) {
        HibernateUtil.beginTransaction();
        this.starManager.removeStar(star.getId().intValue());
        HibernateUtil.commitTransaction();
    }

    private Star createIntStar(StarType type, int intKey1) throws Exception {
        HibernateUtil.beginTransaction();
        StarKey key = new StarKey(type.getName());
        key.setIntKey1(Integer.valueOf(intKey1));
        Star star = this.starManager.addStar(key, this.userLogin);
        HibernateUtil.commitTransaction();
        return star;
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

