/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.activity;

import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.atlassian.crucible.activity.review.ReviewCommentActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemProvider;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReviewCommentActivityItemProviderTest
extends ActivityItemTestBase {
    private Review review1;
    private Review review2;
    private String review1Csid = "MAIN:matt:20041205010425";
    private Path pathUnderReview1 = new Path((CharSequence)"emptytests/notempty/a.txt");
    private String review2Csid = "MAIN:matt:20050113032653";
    private Path notUnderReview = new Path((CharSequence)"test/CleanSweeper.java");
    private Comment comment1;
    private Comment comment2;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HibernateUtil.beginTransaction();
        this.review1 = this.reviewManager.createReview(this.pm, this.pm.getDefaultProject(), "test review1", this.currentUser);
        this.review1.setModerator(this.currentUser);
        this.review1.setAuthor(this.currentUser);
        this.review1.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch1 = new ReviewCreationHelper(this.cvsSource, this.review1, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        this.review2 = this.reviewManager.createReview(this.pm, this.pm.getDefaultProject(), "test review1 2", this.currentUser);
        this.review2.setModerator(this.currentUser);
        this.review2.setAuthor(this.currentUser);
        this.review2.setCreator(this.currentUser);
        HibernateUtil.commitTransaction();
        ReviewCreationHelper cvsRch2 = new ReviewCreationHelper(this.cvsSource, this.review2, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.spiUtils, this.commentManager, this.eventPublisher);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch1, this.cvsSource, this.currentUser, this.review1Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment1 = this.commentManager.createComment("comment1 on " + this.review1Csid, this.review1, this.currentUser);
        this.reviewManager.changeState(this.review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(cvsRch2, this.cvsSource, this.currentUser, this.review2Csid, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        this.comment2 = this.commentManager.createComment("comment2 on " + this.review2Csid, this.review2, this.currentUser);
        this.reviewManager.changeState(this.review2, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
    }

    @Override
    public void tearDown() throws Exception {
        this.currentUser = null;
        this.currentUserLogin = null;
        this.cvsSource = null;
        this.review1 = null;
        this.review2 = null;
        this.cvsHandle = null;
        super.tearDown();
    }

    private ActivityItemSearchParams buildParams(SearchSortOrder direction, Path path) {
        ActivityItemSearchParams.Builder builder = ActivityItemSearchParams.builder();
        builder.path("cvs", path).maxDate(new Date()).minDate(new Date(0L)).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).searchDirection(direction).maxItems(10).includeCrucible();
        return builder.build();
    }

    @Test
    public void testFindCommentsWithPathConstraint() throws SourceException {
        ActivityItemProvider reviewCommentActivityItemProvider = (ActivityItemProvider)SpringContext.getComponent((String)"reviewCommentActivityItemProvider");
        ActivityItemList ail = reviewCommentActivityItemProvider.findActivityItems(this.buildParams(SearchSortOrder.TOWARDS_PAST, this.pathUnderReview1), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)1L, (long)ail.getItems().size());
        Assert.assertTrue((boolean)(ail.getItems().get(0) instanceof ReviewCommentActivityItem));
        ReviewCommentActivityItem item = (ReviewCommentActivityItem)ail.getItems().get(0);
        Assert.assertEquals((Object)this.comment1.getMessage(), (Object)item.getComment().getMessage());
        ail = reviewCommentActivityItemProvider.findActivityItems(this.buildParams(SearchSortOrder.TOWARDS_PAST, this.notUnderReview), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)0L, (long)ail.getItems().size());
        ail = reviewCommentActivityItemProvider.findActivityItems(this.buildParams(SearchSortOrder.TOWARDS_PAST, Path.ROOT), (Principal)this.currentUserLogin, new ActivitySearchMonitor());
        Assert.assertEquals((long)0L, (long)ail.getExceptions().size());
        Assert.assertEquals((long)2L, (long)ail.getItems().size());
        boolean seenComment1 = false;
        boolean seenComment2 = false;
        for (Object i : ail.getItems()) {
            Assert.assertTrue((boolean)(i instanceof ReviewCommentActivityItem));
            item = (ReviewCommentActivityItem)i;
            if (this.comment1.getMessage().equals(item.getComment().getMessage()) && this.comment1.getId().equals(item.getComment().getId())) {
                seenComment1 = true;
                continue;
            }
            if (this.comment2.getMessage().equals(item.getComment().getMessage()) && this.comment2.getId().equals(item.getComment().getId())) {
                seenComment2 = true;
                continue;
            }
            Assert.fail((String)("wrong comment found:id=" + item.getComment().getId() + " message=" + item.getComment().getMessage()));
        }
        Assert.assertTrue((String)("failed to find the correct comments in:" + ail.getItems()), (seenComment1 && seenComment2 ? 1 : 0) != 0);
    }
}

