/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.snippet;

import com.atlassian.crucible.actions.snippet.CreateSnippetAjaxAction;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.UserActionManager;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CreateSnippetAjaxActionTest {
    private CreateSnippetAjaxAction createSnippetAjaxActionHasProjects;
    private CreateSnippetAjaxAction createSnippetAjaxActionHasNoProjects;

    @Before
    public void setUp() {
        this.createSnippetAjaxActionHasProjects = (CreateSnippetAjaxAction)Mockito.spy((Object)new CreateSnippetAjaxAction(){

            protected void beginTx() {
            }

            protected void commitTx() {
            }
        });
        ((CreateSnippetAjaxAction)Mockito.doReturn(Arrays.asList(new Project())).when((Object)this.createSnippetAjaxActionHasProjects)).getProjectsCanDoActionIn(UserActionManager.Action.ACTION_CREATE);
        this.createSnippetAjaxActionHasNoProjects = (CreateSnippetAjaxAction)Mockito.spy((Object)new CreateSnippetAjaxAction(){

            protected void beginTx() {
            }

            protected void commitTx() {
            }
        });
        ((CreateSnippetAjaxAction)Mockito.doReturn((Object)Collections.EMPTY_LIST).when((Object)this.createSnippetAjaxActionHasNoProjects)).getProjectsCanDoActionIn(UserActionManager.Action.ACTION_CREATE);
    }

    @Test
    public void testExecuteHasProjects() throws Exception {
        Assert.assertThat((Object)this.createSnippetAjaxActionHasProjects.execute(), (Matcher)IsEqual.equalTo((Object)"ajaxRedirect"));
    }

    @Test
    public void testExecuteHasNoProjects() throws Exception {
        Assert.assertThat((Object)this.createSnippetAjaxActionHasNoProjects.execute(), (Matcher)IsEqual.equalTo((Object)"ajaxError"));
    }

    @Test
    public void testGetErrorMsgHasNoProjects() throws Exception {
        this.createSnippetAjaxActionHasNoProjects.execute();
        Assert.assertThat((Object)this.createSnippetAjaxActionHasNoProjects.getErrorMsg(), (Matcher)IsEqual.equalTo((Object)"You do not have permission to create snippets in any project."));
    }

    @Test
    public void testIsWorkedHasNoProjects() throws Exception {
        this.createSnippetAjaxActionHasNoProjects.execute();
        Assert.assertThat((Object)this.createSnippetAjaxActionHasNoProjects.isWorked(), (Matcher)IsEqual.equalTo((Object)false));
        Assert.assertThat((Object)this.createSnippetAjaxActionHasNoProjects.getPath(), (Matcher)IsEqual.equalTo((Object)"/snippet/create"));
    }
}

