/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.search.ajax;

import com.atlassian.crucible.actions.search.ajax.ReviewerFinderAjaxAction;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReviewerFinderAjaxActionTest {
    @Mock
    UserManager mockUuserManager;
    @Mock
    ReviewManager mockReviewManager;
    ReviewerFinderAjaxAction action;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Review review;

    @Before
    public void setUp() throws Exception {
        this.action = new ReviewerFinderAjaxAction(){
            {
                this.userManager = ReviewerFinderAjaxActionTest.this.mockUuserManager;
                this.reviewManager = ReviewerFinderAjaxActionTest.this.mockReviewManager;
            }
        };
    }

    @Test
    public void testDoesntReturnDuplicates() throws Exception {
        FecruUser user1 = new FecruUser("user1");
        FecruUser user2 = new FecruUser("user2");
        String query = "user";
        this.action.setQ("user");
        this.action.setPermaKeyProject("CR");
        this.action.setPermaKeyNumber(111);
        Mockito.when((Object)this.mockReviewManager.getReviewByPermaId((PermaIdKey)org.mockito.Matchers.any(PermaIdKey.class))).thenReturn((Object)this.review);
        Mockito.when((Object)this.mockUuserManager.searchUsers((UserSearchCriteria)org.mockito.Matchers.eq((Object)UserSearchCriteria.create().named("user").withPermissions(GlobalPermissionType.CRUCIBLE_USER)), (PageRequest)org.mockito.Matchers.any(PageRequest.class))).thenReturn((Object)Page.Builder.buildFromAllDataIterable((Iterable)ImmutableList.of((Object)user1, (Object)user2), (PageRequest)PageRequest.createDefault()));
        this.action.execute();
        Collection matches = this.action.getMatches();
        MatcherAssert.assertThat((Object)matches, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)matches, (Matcher)Matchers.containsInAnyOrder((Object[])new ReviewerFinderAjaxAction.ReviewerData[]{new ReviewerFinderAjaxAction.ReviewerData(user1), new ReviewerFinderAjaxAction.ReviewerData(user2)}));
    }
}

