/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create.ajax;

import com.atlassian.crucible.actions.create.ajax.EditConstraintsAjaxAction;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EditConstraintsAjaxActionTest {
    @Mock
    UserManager userManager;
    public static final Function<String, EditConstraintsAjaxAction.ConstraintsMatch> STRING_TO_CONSTRAINT_MATCH = EditConstraintsAjaxAction.ConstraintsMatch::new;
    private final FecruUser[] users = new FecruUser[]{this.createUser("conor", "Conor MacNeill"), this.createUser("wookieb", "Lukasz Kuzynski"), this.createUser("lpater", "Lukasz Pater")};
    private final String[] branches = new String[]{"3.3-FE-5022-changesets-user-filter", "3.3-FECRU-4450-lazy-load-tmp-diff-files", "3.3-FECRU-4467-inconsistent-icon-in-header", "3.3-FECRU-4469-ChunkedManifestUpgrade", "3.3-FECRU-4472-improve-thread-names", "3.3-FECRU-4493-jsp-complex-datatypes", "33-FECRU-4467-file-icon-in-header-is-displa", "33-FECRU-4509-continual-refreshing-of-the-c", "FECRU-4471-when-creating-review-pressing", "default"};
    @Mock
    EffectiveUserProvider effectiveUserProvider;
    @InjectMocks
    private final EditConstraintsAjaxAction action = new EditConstraintsAjaxAction(){

        public Set<FecruUser> getAvailableUsers() throws DbException {
            return Sets.newHashSet((Object[])EditConstraintsAjaxActionTest.this.users);
        }

        public List<String> getAvailableBranches() {
            return Arrays.asList(EditConstraintsAjaxActionTest.this.branches);
        }
    };

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.getEffectiveUser()).thenReturn((Object)this.users[0]);
    }

    private FecruUser createUser(String userName, String displayName) {
        FecruUser fuser = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)fuser.getUsername()).thenReturn((Object)userName);
        Mockito.when((Object)fuser.getEmail()).thenReturn((Object)"");
        Mockito.when((Object)fuser.getDisplayName()).thenReturn((Object)displayName);
        return fuser;
    }

    @Test
    public void testBranchesFilteringForEmptyQuery() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("", "branches");
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])this.toArrayOfConstraints(this.branches)));
    }

    private EditConstraintsAjaxAction.ConstraintsMatch[] toArrayOfConstraints(String[] branches) {
        return (EditConstraintsAjaxAction.ConstraintsMatch[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(branches), STRING_TO_CONSTRAINT_MATCH), EditConstraintsAjaxAction.ConstraintsMatch.class);
    }

    @Test
    public void testBranchFiltering() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("thr", "branches");
        String[] expectedBranches = new String[]{"3.3-FECRU-4472-improve-thread-names"};
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])this.toArrayOfConstraints(expectedBranches)));
    }

    @Test
    public void testBranchFilteringWithHyphen() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("fecru-44", "branches");
        String[] expectedBranches = new String[]{"3.3-FECRU-4450-lazy-load-tmp-diff-files", "3.3-FECRU-4467-inconsistent-icon-in-header", "3.3-FECRU-4469-ChunkedManifestUpgrade", "3.3-FECRU-4472-improve-thread-names", "3.3-FECRU-4493-jsp-complex-datatypes", "33-FECRU-4467-file-icon-in-header-is-displa", "FECRU-4471-when-creating-review-pressing"};
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])this.toArrayOfConstraints(expectedBranches)));
    }

    @Test
    public void testUsersFilteringForEmptyQuery() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("", "users");
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])new EditConstraintsAjaxAction.ConstraintsMatch[]{new EditConstraintsAjaxAction.ConstraintsMatch("Conor MacNeill", "conor", "conor"), new EditConstraintsAjaxAction.ConstraintsMatch("Lukasz Kuzynski", "wookieb", "wookieb"), new EditConstraintsAjaxAction.ConstraintsMatch("Lukasz Pater", "lpater", "lpater")}));
    }

    @Test
    public void testUsersFilteringByDisplayName() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("luk", "users");
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])new EditConstraintsAjaxAction.ConstraintsMatch[]{new EditConstraintsAjaxAction.ConstraintsMatch("Lukasz Kuzynski", "wookieb", "wookieb"), new EditConstraintsAjaxAction.ConstraintsMatch("Lukasz Pater", "lpater", "lpater")}));
    }

    @Test
    public void testUsersFilteringByName() {
        Collection<EditConstraintsAjaxAction.ConstraintsMatch> matches = this.executeFilter("con", "users");
        Assert.assertThat(matches, (Matcher)Matchers.contains((Object[])new EditConstraintsAjaxAction.ConstraintsMatch[]{new EditConstraintsAjaxAction.ConstraintsMatch("Conor MacNeill", "conor", "conor")}));
    }

    private Collection<EditConstraintsAjaxAction.ConstraintsMatch> executeFilter(String query, String command) {
        this.action.setCommand(command);
        this.action.setQ(query);
        try {
            this.action.execute();
            return this.action.getMatches();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute action", e);
        }
    }
}

