/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.EditReviewDetailsAction;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.user.UserManager;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EditReviewDetailsActionTest {
    @Mock
    ReviewManager reviewManager;
    @Mock
    PermissionManager permissionManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Review review = new Review();
    EditReviewDetailsAction action;
    private UserManager userManager;
    private ProjectManager projectManager;

    @Before
    public void setUp() throws Exception {
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        this.projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.action = new EditReviewDetailsAction(){
            {
                this.userManager = EditReviewDetailsActionTest.this.userManager;
                this.projectManager = EditReviewDetailsActionTest.this.projectManager;
                this.reviewManager = EditReviewDetailsActionTest.this.reviewManager;
                this.permissionManager = EditReviewDetailsActionTest.this.permissionManager;
                this.spiUtils = (SPIUtils)Mockito.mock(SPIUtils.class);
                this.notificationManager = (NotificationManager)Mockito.mock(NotificationManager.class);
                this.eventPublisher = (EventPublisher)Mockito.mock(EventPublisher.class);
            }

            protected void beginTx() {
            }

            protected void commitTx() {
            }

            protected void log(ReviewMutableProperties property, String oldValue, String newValue) {
            }

            public FecruUser getCurrentUser() {
                return new FecruUser("user");
            }
        };
        this.action.setSPIUserUtils((SPIUserUtils)Mockito.mock(SPIUserUtils.class));
        this.action.setCommand("foo");
        this.action.setPermaKeyProject("CR");
        this.action.setPermaKeyNumber(111);
    }

    @Test
    public void testExecute_doesntFailIfAuthorDoesntExistAnymore() throws Exception {
        Mockito.when((Object)this.reviewManager.getReviewByPermaId((PermaIdKey)Matchers.any(PermaIdKey.class))).thenReturn((Object)this.review);
        Mockito.when((Object)this.permissionManager.canEffectivePrincipalDoReviewAction((Review)Matchers.same((Object)this.review), (UserActionManager.Action)Matchers.any(UserActionManager.Action.class))).thenReturn((Object)true);
        Mockito.when((Object)this.projectManager.getProjectByKey("CR")).thenReturn((Object)new Project());
        this.action.setNewAuthor(12);
        this.action.setProjectKey("CR");
        this.action.execute();
        ((Review)Mockito.verify((Object)this.review)).setParticipants((Map)Matchers.argThat((Matcher)AllOf.allOf((Matcher)IsMapContaining.hasKey((Object)this.review.getAuthor()), (Matcher)IsMapContaining.hasKey((Object)this.review.getModerator()))));
    }

    @Test
    public void testExecute_setsAuthor() throws Exception {
        FecruUser newAuthor = new FecruUser(Integer.valueOf(12), "user12");
        Mockito.when((Object)this.reviewManager.getReviewByPermaId((PermaIdKey)Matchers.any(PermaIdKey.class))).thenReturn((Object)this.review);
        Mockito.when((Object)this.permissionManager.canEffectivePrincipalDoReviewAction((Review)Matchers.same((Object)this.review), (UserActionManager.Action)Matchers.any(UserActionManager.Action.class))).thenReturn((Object)true);
        Mockito.when((Object)this.userManager.getLicensedUser(newAuthor.getId().intValue())).thenReturn((Object)newAuthor);
        Mockito.when((Object)this.projectManager.getProjectByKey("CR")).thenReturn((Object)new Project());
        this.action.setNewAuthor(newAuthor.getId().intValue());
        this.action.setProjectKey("CR");
        this.action.execute();
        ((Review)Mockito.verify((Object)this.review)).setParticipants((Map)Matchers.argThat((Matcher)AllOf.allOf((Matcher)IsMapContaining.hasKey((Object)newAuthor), (Matcher)IsMapContaining.hasKey((Object)this.review.getModerator()))));
    }

    @Test
    public void testInvalidProject() throws Exception {
        Mockito.when((Object)this.reviewManager.getReviewByPermaId((PermaIdKey)Matchers.any(PermaIdKey.class))).thenReturn((Object)this.review);
        Mockito.when((Object)this.permissionManager.canEffectivePrincipalDoReviewAction((Review)Matchers.same((Object)this.review), (UserActionManager.Action)Matchers.any(UserActionManager.Action.class))).thenReturn((Object)true);
        Mockito.when((Object)this.projectManager.getProjectByKey("BLAH")).thenReturn(null);
        this.action.setProjectKey("BLAH");
        String result = this.action.execute();
        Assert.assertEquals((String)"Action should return an ajax error", (Object)"ajaxError", (Object)result);
        String errorMessage = this.action.getErrorMsg();
        Assert.assertEquals((String)"Error message should state project is invalid", (Object)"The project key BLAH does not refer to a valid project", (Object)errorMessage);
    }
}

