/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.CreateReviewFromChangesetAjaxAction;
import com.atlassian.crucible.event.ReviewCreateJiraAdded;
import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.CrucibleChangeSetsHelper;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fecru.review.StripedLockReviewLockManager;
import com.atlassian.fecru.test.UserPrincipal;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.atlassian.fisheye.user.model.RecentlyVisitedProject;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.ProjectBuilder;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CreateReviewFromChangesetAjaxActionTest {
    private static final String REPO1 = "repo1";
    private static final String REPO2 = "repo2";
    private final Project project1 = new ProjectBuilder().key("PROJ1").name("Project 1").build();
    private final Project project2 = new ProjectBuilder().key("PROJ2").name("Project 2").build();
    private final Project project3 = new ProjectBuilder().key("PROJ3").name("Project 3").build();
    private final List<Project> availableProjects = ImmutableList.of((Object)this.project1, (Object)this.project2, (Object)this.project3);
    private static final FecruUser USER = new FecruUser("CreateReviewFromChangesetAjaxActionTest");
    private static final Principal PRINCIPAL = new UserPrincipal(USER.getUsername(), USER.getDisplayName());
    @Mock
    RecentlyVisitedManager recentlyVisitedManager;
    @Mock
    TxHelper txHelper;
    @Mock
    EffectiveUserProvider effectiveUserProvider;
    @Mock
    ReviewManager reviewManager;
    @Mock
    CommitterUserMappingManager committerMappingManager;
    @Mock
    Source source;
    @Mock
    JiraIssueService jiraIssueService;
    @Mock
    ReviewService reviewService;
    @Mock
    CrucibleChangeSetsHelper ccsHelper;
    @Mock
    PermissionManager permissionManager;
    @Mock
    XsrfTokenValidator xsrfTokenValidator;
    @Mock
    ChangesetSearcher changesetSearcher;
    @Mock
    ProjectManager projectManager;
    @Mock
    EventPublisher eventPublisher;
    @InjectMocks
    private final CreateReviewFromChangesetAjaxAction action = new CreateReviewFromChangesetAjaxAction(){

        public List<Project> getProjectsCanCreateIn() {
            return CreateReviewFromChangesetAjaxActionTest.this.availableProjects;
        }
    };

    @Before
    public void setUp() throws Exception {
        this.action.setReviewLockManager((ReviewLockManager)new StripedLockReviewLockManager());
        this.action.setEventPublisher(this.eventPublisher);
        Mockito.when((Object)this.effectiveUserProvider.getEffectiveUser()).thenReturn((Object)USER);
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)PRINCIPAL);
        Mockito.when((Object)this.permissionManager.canPrincipalCreateIn((Principal)Matchers.any(Principal.class), (Project)Matchers.any(Project.class))).thenReturn((Object)true);
        Mockito.when((Object)this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)true);
        this.action.setCsid(new String[]{"1"});
        Mockito.when((Object)this.ccsHelper.createChangeSets(false)).thenAnswer(invocation -> Lists.newArrayList((Iterable)Lists.transform(Arrays.asList(this.action.getCsid()), csid -> new CrucibleChangeSet(csid, csid, Collections.emptyList(), csid, new Date(), "author", this.source))));
    }

    @Test
    public void testExecute_projectNameGiven() throws Exception {
        this.action.setCrucibleProject(this.project2.getProjKey());
        this.mockReviewManagerCreateReviewWithDefaults(this.project2);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"done"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_noProjectNameOrRepoGiven() throws Exception {
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project1));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project1));
    }

    @Test
    public void testExecute_RepoNameGiven_oneMatches() throws Exception {
        this.setUpProjectsMatchRepo("testExecute_RepoNameGiven_oneMatches", this.project3);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"done"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project3));
    }

    @Test
    public void testExecute_RepoNameGiven_manyMatch() throws Exception {
        this.setUpProjectsMatchRepo("testExecute_RepoNameGiven_manyMatch", this.project2, this.project3);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_RepoNameFromCsid_manyMatch() throws Exception {
        this.project1.setDefaultRepositoryName(REPO1);
        this.project2.setDefaultRepositoryName(REPO1);
        this.action.setCsid(new String[]{ChangeSetPair.newInstance((String)REPO1, (String)"123").toString()});
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project1));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project1));
    }

    @Test
    public void testExecute_RepoNameFromCsid_oneMatches() throws Exception {
        this.project2.setDefaultRepositoryName(REPO1);
        this.mockReviewManagerCreateReviewWithDefaults(this.project2);
        this.action.setCsid(new String[]{ChangeSetPair.newInstance((String)REPO1, (String)"123").toString()});
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"done"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_RepoNameFromMultipleCsid_oneMatches() throws Exception {
        this.project2.setDefaultRepositoryName(REPO1);
        this.mockReviewManagerCreateReviewWithDefaults(this.project2);
        this.action.setCsid(new String[]{ChangeSetPair.newInstance((String)REPO1, (String)"123").toString(), ChangeSetPair.newInstance((String)REPO1, (String)"456").toString()});
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"done"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_RepoNameFromMultipleCsid_manyMatch() throws Exception {
        this.project2.setDefaultRepositoryName(REPO1);
        this.project3.setDefaultRepositoryName(REPO2);
        this.action.setCsid(new String[]{ChangeSetPair.newInstance((String)REPO1, (String)"123").toString(), ChangeSetPair.newInstance((String)REPO2, (String)"456").toString()});
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_picksMostRecentlyUsedCandidate() throws Exception {
        this.project2.setDefaultRepositoryName(REPO1);
        this.project3.setDefaultRepositoryName(REPO1);
        this.action.setCsid(new String[]{ChangeSetPair.newInstance((String)REPO1, (String)"123").toString()});
        List<RecentlyVisitedProject> recentProjects = this.createRecentlyVisitedList(this.project1, this.project3, this.project2);
        Mockito.when((Object)this.recentlyVisitedManager.getHistory(RecentlyVisitedItem.Type.PROJECT, PRINCIPAL)).thenReturn(recentProjects);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project3));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project3));
    }

    @Test
    public void testExecute_picksMostRecentlyUsedAvailableIfNoCandidates() throws Exception {
        List<RecentlyVisitedProject> recentProjects = this.createRecentlyVisitedList(this.project2, this.project1, this.project3);
        Mockito.when((Object)this.recentlyVisitedManager.getHistory(RecentlyVisitedItem.Type.PROJECT, PRINCIPAL)).thenReturn(recentProjects);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    private List<RecentlyVisitedProject> createRecentlyVisitedList(Project ... projects) {
        return ImmutableList.copyOf((Collection)Lists.transform(Arrays.asList(projects), project -> {
            RecentlyVisitedProject mockItem = (RecentlyVisitedProject)Mockito.mock(RecentlyVisitedProject.class);
            Mockito.when((Object)mockItem.getEntity()).thenReturn(project);
            return mockItem;
        }));
    }

    @Test
    public void testExecute_NullRequestedRepoReviewHasProperMacroChangesetLink() throws Exception {
        String changesetId = "6sabbeef";
        this.action.setCsid(new String[]{"6sabbeef"});
        this.setUpProjectsMatchRepo("FOO-1", this.project3);
        Review review = new Review(){

            public void setModerator(FecruUser user) {
            }

            public void setAuthor(FecruUser user) {
            }
        };
        review.setId(Integer.valueOf(Integer.MIN_VALUE));
        Mockito.when((Object)this.source.getName()).thenReturn((Object)REPO1);
        Mockito.when((Object)this.reviewManager.createReviewWithDefaults((ProjectManager)Matchers.any(ProjectManager.class), (Project)Matchers.any(Project.class), Matchers.anyString(), (FecruUser)Matchers.any(FecruUser.class))).thenReturn((Object)review);
        this.action.execute();
        String result = this.action.getReview().getDescription();
        String expected = String.format("{%s:%s=%s|%s=%s}: %s", "cs", "id", "6sabbeef", "rep", REPO1, "6sabbeef");
        Assert.assertEquals((String)"Produced cs", (Object)result, (Object)expected);
    }

    @Test
    public void testExtractRequestedRepositories_WithoutChangesetIdShouldHaveRequestedRepo() throws Exception {
        String requestedRepo = "FOO-1";
        this.action.setRepo("FOO-1");
        this.action.setCsid(null);
        Set result = this.action.extractRequestedRepositories();
        Assert.assertEquals((String)"Returned set should contain only entity", (long)1L, (long)result.size());
        Assert.assertTrue((String)String.format("Expected FOO-1 repo only but was %s", result), (boolean)result.contains("FOO-1"));
    }

    @Test
    public void testExtractRequestedRepositories_WithoutChangesetIdAndRequestedRepoShouldHaveEmptySet() throws Exception {
        this.action.setRepo(null);
        this.action.setCsid(null);
        Set result = this.action.extractRequestedRepositories();
        Assert.assertTrue((String)"Given none CsId And RequestedRepo returned set should be empty", (boolean)result.isEmpty());
    }

    @Test
    public void testExecute_MatchOneJiraProjectFromComments() throws Exception {
        this.action.setCsid(new String[]{"FOO-1: fixed foobar", "FOO-15: fixed barbar, broke STUFF", "BAR-42"});
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects(this.availableProjects, "FOO")).thenReturn(Collections.singletonList(this.project3));
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects(this.availableProjects, "BAR")).thenReturn(Collections.singletonList(this.project3));
        ((ReviewService)Mockito.doAnswer(invocation -> null).when((Object)this.reviewService)).tryAutomaticJiraLinking(new PermId(""));
        this.mockReviewManagerCreateReviewWithDefaults(this.project3);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"done"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project3));
    }

    @Test
    public void testExecute_MatchManyJiraProjectsFromComments() throws Exception {
        this.action.setCsid(new String[]{"FOO-1: fixed foobar", "FOO-15: fixed barbar, broke STUFF", "BAR-42"});
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects(this.availableProjects, "FOO")).thenReturn(Collections.singletonList(this.project3));
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects(this.availableProjects, "BAR")).thenReturn(Collections.singletonList(this.project2));
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    @Test
    public void testExecute_createNewReview_InvalidXsrfTokenCausesConfirmationIfProjectFound() throws Exception {
        this.setUpProjectsMatchRepo("testExecute_createNewReview_InvalidXsrfTokenCausesSelectProjectDialogIfProjectFound", this.project3);
        Mockito.when((Object)this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)false);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Object)"selectProject"));
        Assert.assertThat((Object)this.action.isConfirmCreateRequested(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void testExecute_createNewReview_InvalidXsrfTokenDoesntCauseConfirmIfProjectNotFound() throws Exception {
        Mockito.when((Object)this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)false);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Object)"selectProject"));
        Assert.assertThat((Object)this.action.isConfirmCreateRequested(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void testExecute_createNewReview_InvalidXsrfTokenDoesntCauseConfirmIfManyProjectsFound() throws Exception {
        Mockito.when((Object)this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)false);
        this.setUpProjectsMatchRepo("testExecute_createNewReview_InvalidXsrfTokenDoesntCauseConfirmIfManyProjectsFound", this.project2, this.project3);
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Object)"selectProject"));
        Assert.assertThat((Object)this.action.isConfirmCreateRequested(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void testExecute_addToReview_InvalidXsrfTokenCausesXsrfError() throws Exception {
        Mockito.when((Object)this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)false);
        this.action.setTask("CR-2");
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Object)"xsrfError"));
    }

    @Test
    public void testExecute_createFromJiraIssue() throws Exception {
        String[] issueKeys = new String[]{"BAR-1", "RAR-2"};
        Mockito.when((Object)this.projectManager.getProjectByKey(this.project1.getProjKey())).thenReturn((Object)this.project1);
        this.action.setIssueKey(issueKeys);
        this.action.setIssueSummary("summary");
        this.action.setIssueDescription("description");
        this.action.setCsid(null);
        Review review = this.mockReviewManagerCreateReviewWithDefaults(this.project1);
        Mockito.when((Object)this.changesetSearcher.getChangesetsForQuery((ChangesetQueryBuilder)Matchers.any(ChangesetQueryBuilder.class))).thenReturn((Object)ImmutableList.of((Object)ChangeSetPair.newInstance((String)"fe", (String)"FOO-1"), (Object)ChangeSetPair.newInstance((String)"fe", (String)"MOO-1")));
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects((Iterable)Matchers.eq(this.availableProjects), Matchers.anyString())).thenReturn(Collections.singleton(this.project1));
        this.action.execute();
        ((Review)Mockito.verify((Object)review)).setName("BAR-1: summary");
        ((Review)Mockito.verify((Object)review)).setDescription("description");
        ((CrucibleChangeSetsHelper)Mockito.verify((Object)this.ccsHelper)).addCrucibleChangeSet(ChangeSetPair.newInstance((String)"fe", (String)"FOO-1"));
        ((CrucibleChangeSetsHelper)Mockito.verify((Object)this.ccsHelper)).addCrucibleChangeSet(ChangeSetPair.newInstance((String)"fe", (String)"MOO-1"));
        ((JiraIssueService)Mockito.verify((Object)this.jiraIssueService)).findLinkedCrucibleProjects(this.availableProjects, "BAR");
        ((JiraIssueService)Mockito.verify((Object)this.jiraIssueService)).findLinkedCrucibleProjects(this.availableProjects, "RAR");
        ((JiraIssueService)Mockito.verify((Object)this.jiraIssueService)).findLinkedCrucibleProjects(this.availableProjects, "FOO");
        ((JiraIssueService)Mockito.verify((Object)this.jiraIssueService)).findLinkedCrucibleProjects(this.availableProjects, "MOO");
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher)).publish(Matchers.any(ReviewCreateJiraAdded.class));
    }

    @Test
    public void testExecute_createFromJiraIssue_preselectsFirstLinkedProject() throws Exception {
        this.action.setIssueKey(new String[]{"BAR-1"});
        Mockito.when((Object)this.jiraIssueService.findLinkedCrucibleProjects(this.availableProjects, "BAR")).thenReturn((Object)ImmutableList.of((Object)this.project2, (Object)this.project3));
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.equalTo((Object)"selectProject"));
        Assert.assertThat((Object)this.action.getProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
        Assert.assertThat((Object)this.action.getPreSelectedProject(), (Matcher)org.hamcrest.Matchers.is((Object)this.project2));
    }

    private void setUpProjectsMatchRepo(String repoName, Project ... reviewProjects) {
        this.action.setRepo(repoName);
        for (Project reviewProject : reviewProjects) {
            reviewProject.setDefaultRepositoryName(repoName);
            this.mockReviewManagerCreateReviewWithDefaults(reviewProject);
        }
    }

    private Review mockReviewManagerCreateReviewWithDefaults(Project reviewProject) {
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)this.reviewManager.createReviewWithDefaults((ProjectManager)Matchers.any(ProjectManager.class), (Project)Matchers.eq((Object)reviewProject), Matchers.anyString(), (FecruUser)Matchers.eq((Object)USER))).thenReturn((Object)review);
        return review;
    }
}

