/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.AnchorPatchAjaxAction;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.util.PatchAnchorHelper;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AnchorPatchAjaxActionTest {
    private AnchorPatchAjaxAction anchorPatchAjaxAction;
    private PatchAnchorHelper patchAnchorHelper;
    private SourceFactory sourceFactory;

    @Before
    public void setUp() throws Exception {
        this.patchAnchorHelper = (PatchAnchorHelper)Mockito.mock(PatchAnchorHelper.class);
        this.sourceFactory = (SourceFactory)Mockito.mock(SourceFactory.class);
        PermissionManager permissionManager = (PermissionManager)Mockito.mock(PermissionManager.class);
        Mockito.when((Object)permissionManager.canEffectivePrincipalDoReviewAction((Review)Matchers.any(), (UserActionManager.Action)Matchers.any())).thenReturn((Object)true);
        Review review = new Review();
        State state = new State();
        state.setStateType(StateManager.States.REVIEW_STATE);
        review.setState(state);
        ReviewManager reviewManager = (ReviewManager)Mockito.mock(ReviewManager.class);
        Mockito.when((Object)reviewManager.getReviewByPermaId((PermaIdKey)Matchers.any(PermaIdKey.class))).thenReturn((Object)review);
        PatchManager patchManager = (PatchManager)Mockito.mock(PatchManager.class);
        Patch patch = (Patch)Mockito.mock(Patch.class);
        Mockito.when((Object)patch.getReview()).thenReturn((Object)review);
        Mockito.when((Object)patchManager.getPatchById((Integer)Matchers.any())).thenReturn((Object)patch);
        this.anchorPatchAjaxAction = new AnchorPatchAjaxAction(this.patchAnchorHelper, permissionManager, patchManager);
        this.anchorPatchAjaxAction.setSourceFactory(this.sourceFactory);
        this.anchorPatchAjaxAction.setReviewManager(reviewManager);
        this.anchorPatchAjaxAction.setTxTemplate((TxTemplate)new DummyTxTemplate());
        this.anchorPatchAjaxAction.setEffectiveUserProvider((EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class));
        this.anchorPatchAjaxAction.setPermaKeyProject("keyProject");
    }

    @Test
    public void testSearchWithOneSearchRepoSuccess() throws Exception {
        String sourceName = "some";
        this.anchorPatchAjaxAction.setAllrepos(false);
        this.anchorPatchAjaxAction.setShowCandidatePaths(false);
        this.anchorPatchAjaxAction.setSearch(true);
        this.anchorPatchAjaxAction.setAnchorSource("some");
        RepositorySource source = (RepositorySource)Mockito.mock(RepositorySource.class);
        PatchAnchorHelper.PatchAnchorResult success = PatchAnchorHelper.PatchAnchorResult.success((RepositorySource)source);
        Mockito.when((Object)this.sourceFactory.getSource((String)Matchers.eq((Object)"some"), (Principal)Matchers.any())).thenReturn((Object)source);
        Mockito.when((Object)this.patchAnchorHelper.anchorPatch((ContentManager)Matchers.any(), (Patch)Matchers.any(), (PatchSource)Matchers.any(), (Source)Matchers.eq((Object)source), (EggTimer)Matchers.any())).thenReturn((Object)success);
        this.anchorPatchAjaxAction.execute();
        boolean result = this.anchorPatchAjaxAction.isAnchorSucceeded();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testSearchWithOneSearchRepoError() throws Exception {
        String sourceName = "some";
        String errorMsg = "errorMsg";
        this.anchorPatchAjaxAction.setAllrepos(false);
        this.anchorPatchAjaxAction.setShowCandidatePaths(false);
        this.anchorPatchAjaxAction.setSearch(true);
        this.anchorPatchAjaxAction.setAnchorSource("some");
        RepositorySource source = (RepositorySource)Mockito.mock(RepositorySource.class);
        PatchAnchorHelper.PatchAnchorResult error = PatchAnchorHelper.PatchAnchorResult.error((String)"errorMsg");
        Mockito.when((Object)this.sourceFactory.getSource((String)Matchers.eq((Object)"some"), (Principal)Matchers.any())).thenReturn((Object)source);
        Mockito.when((Object)this.patchAnchorHelper.anchorPatch((ContentManager)Matchers.any(), (Patch)Matchers.any(), (PatchSource)Matchers.any(), (Source)Matchers.eq((Object)source), (EggTimer)Matchers.any())).thenReturn((Object)error);
        this.anchorPatchAjaxAction.execute();
        boolean result = this.anchorPatchAjaxAction.isAnchorSucceeded();
        String resultErrorMsg = this.anchorPatchAjaxAction.getErrorMsg();
        List candidateRoots = this.anchorPatchAjaxAction.getCandidateRoots();
        Assert.assertFalse((boolean)result);
        Assert.assertTrue((boolean)candidateRoots.isEmpty());
        Assert.assertEquals((Object)"errorMsg", (Object)resultErrorMsg);
    }
}

