/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.CommentsPerReviewSparklineCalculator;
import com.atlassian.crucible.actions.chart.SparkLineCalculator;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.reports.SparkLineResultCache;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserTestHelper;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class PerReviewSparklineCalculatorTest
extends ServiceTestBase {
    @Test
    public void testCommentsPerReview() throws Exception {
        this.subtestCalc(0.0);
        HibernateUtil.beginTransaction();
        FecruUser ziggy = ModelUtils.makeAndSaveUser("ziggy");
        UserLogin currentUser = UserTestHelper.createPrincipal(ziggy.getUsername());
        Review review = ModelUtils.createBlankTestReview("testreview");
        review.setAuthor(ziggy);
        review.setModerator(ziggy);
        HibernateUtil.commitTransaction();
        EventPublisher eventPublisher = (EventPublisher)SpringContext.getComponent((String)"eventPublisher");
        eventPublisher.unregisterAll();
        this.txTemplate = (TxTemplate)SpringContext.getComponent((String)"txTemplate");
        this.txTemplate.setEffectivePrincipal((Principal)currentUser, ziggy);
        this.subtestCalc(0.0);
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review, UserActionManager.ACTION_APPROVE, ziggy);
        HibernateUtil.commitTransaction();
        this.subtestCalc(0.0);
        HibernateUtil.beginTransaction();
        Comment c1 = this.commentManager.createComment("test comment 1", review, review.getAuthor());
        review.addComment(c1);
        HibernateUtil.commitTransaction();
        this.subtestCalc(1.0);
        HibernateUtil.beginTransaction();
        Comment c2 = this.commentManager.createComment("test comment 2", review, review.getAuthor());
        review.addComment(c2);
        HibernateUtil.commitTransaction();
        this.subtestCalc(2.0);
        HibernateUtil.beginTransaction();
        review = ModelUtils.createBlankTestReview("testreview2");
        review.setAuthor(ziggy);
        review.setModerator(ziggy);
        HibernateUtil.commitTransaction();
        this.subtestCalc(2.0);
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review, UserActionManager.ACTION_APPROVE, ziggy);
        HibernateUtil.commitTransaction();
        this.subtestCalc(1.0);
    }

    private void subtestCalc(double expectedSummary) {
        HibernateUtil.beginTransaction();
        SparkLineResultCache cache = new SparkLineResultCache((ReviewManager)this.reviewManager);
        Date start = new Date(0L);
        Date end = new Date(Long.MAX_VALUE);
        CommentsPerReviewSparklineCalculator calc = new CommentsPerReviewSparklineCalculator(start, end, this.commentManager);
        cache.get(ModelUtils.getProjectManager().getDefaultProject(), start, end, (SparkLineCalculator)calc);
        LogRecordProcessor log = calc.getLogRecordProcessor();
        Assert.assertEquals((double)expectedSummary, (double)log.getSummary(), (double)0.01);
        HibernateUtil.commitTransaction();
    }
}

