/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project.data;

import com.atlassian.crucible.actions.admin.project.data.ProjectData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataFactoryImpl;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ProjectDataFactoryImplTest {
    private static final String KEY = "KEY";
    private ProjectDataFactoryImpl projectDataFactory;
    private ProjectManager projectManager;

    @Before
    public void setUp() throws Exception {
        this.projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.projectDataFactory = new ProjectDataFactoryImpl((LinkerFactory)Mockito.mock(LinkerFactory.class), (SPIUserUtils)Mockito.mock(SPIUserUtils.class), (PermissionManager)Mockito.mock(PermissionManager.class));
    }

    @Test
    public void testUpdateProject_shouldNormalizeAllowedReviewerGroups() {
        Project project = this.setupProject();
        ProjectData projectData = this.getProjectData();
        projectData.setAllowedReviewerGroups((Set)Sets.newHashSet((Object[])new String[]{"group1", "group2", "GROUP3"}));
        this.projectDataFactory.updateProject(this.projectManager, projectData);
        Assert.assertThat((Object)project.getAllowedReviewerGroups(), (Matcher)Is.is((Object)ImmutableSet.of((Object)"group1", (Object)"group2", (Object)"group3")));
    }

    @Test
    public void testUpdateProject_shouldNormalizeDefaultReviewerGroups() {
        Project project = this.setupProject();
        ProjectData projectData = this.getProjectData();
        projectData.setDefaultReviewerGroups((Set)Sets.newHashSet((Object[])new String[]{"group1", "group2", "GROUP3"}));
        this.projectDataFactory.updateProject(this.projectManager, projectData);
        Assert.assertThat((Object)project.getDefaultReviewerGroups(), (Matcher)Is.is((Object)ImmutableSet.of((Object)"group1", (Object)"group2", (Object)"group3")));
    }

    private Project setupProject() {
        Project project = new Project();
        project.setProjKey(KEY);
        Mockito.when((Object)this.projectManager.getProjectById(Matchers.anyInt())).thenReturn((Object)project);
        return project;
    }

    private ProjectData getProjectData() {
        ProjectData projectData = new ProjectData();
        projectData.setId(10);
        projectData.setName("Name");
        projectData.setKey(KEY);
        projectData.setPermissionSchemeId(Integer.valueOf(1));
        return projectData;
    }
}

