/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.actions.admin.database.BaseDatabaseAction;
import com.atlassian.crucible.actions.admin.database.TestDBConnectionAjaxAction;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpringDatabaseActionTest
extends UseTestSpringContextTestCase {
    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.getDBControlFactory().setCurrentControl(null);
    }

    @Test
    public void testSprungConstruct() throws Exception {
        Assert.assertTrue((boolean)SpringContext.isSetup());
        BaseDatabaseAction baseDatabaseAction = (BaseDatabaseAction)SpringContext.createComponent(BaseDatabaseAction.class, (int)4);
        this.checkCopy(baseDatabaseAction, TestFishEyeInstances.getDBControlFactory());
    }

    private void checkCopy(BaseDatabaseAction baseDatabaseAction, DBControlFactory dbControlFactory) {
        DatabaseConfig dbConfig = baseDatabaseAction.getDbConfig();
        Assert.assertTrue((dbConfig != dbControlFactory.getCurrentControl().getInfo().getConnectionInfo() ? 1 : 0) != 0);
        Properties p1 = dbConfig.getProperties();
        Properties p2 = dbControlFactory.getCurrentControl().getInfo().getConnectionInfo().getProperties();
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testTestDBConnectionAction() throws Exception {
        Assert.assertTrue((boolean)SpringContext.isSetup());
        TestDBConnectionAjaxAction testDBConnectionAjaxAction = (TestDBConnectionAjaxAction)SpringContext.createComponent(TestDBConnectionAjaxAction.class);
        this.checkCopy((BaseDatabaseAction)testDBConnectionAjaxAction, TestFishEyeInstances.getDBControlFactory());
        Assert.assertTrue((String)"DB Connection failed", (boolean)testDBConnectionAjaxAction.execute().equals("success"));
    }
}

