/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.actions.admin.database.BaseDatabaseAction;
import com.atlassian.crucible.actions.admin.database.TestDBConnectionAjaxAction;
import com.atlassian.crucible.resource.ThreadPool;
import com.cenqua.crucible.helpers.TestDbControlFactory;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BaseDatabaseActionTest {
    private static final File OUTPUT_DIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "output");
    private static final File TEST_DB_DIR = new File(OUTPUT_DIR, "/dbtester/crucible1");
    private ThreadPool threadPool;

    @Before
    public void setUp() throws Exception {
        this.threadPool = new ThreadPool(5, false);
    }

    @After
    public void tearDown() throws Exception {
        this.threadPool.destroy();
    }

    private DatabaseConfig getDBConfig() {
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.HSQL, "jdbc:hsqldb:file:" + TEST_DB_DIR.getAbsolutePath(), "sa", "", DriverSource.BUNDLED, 5, 5);
        dbconfig.setParam("hsqldb.log_size", "100");
        return dbconfig;
    }

    @Test
    public void testCopyConfig() {
        DBControlFactoryImpl dbControlFactory = new DBControlFactoryImpl(OUTPUT_DIR, TestDbControlFactory.SQL_SCRIPT_BASE_DIR);
        dbControlFactory.setCurrentControl(dbControlFactory.makeControl(this.getDBConfig()));
        BaseDatabaseAction baseDatabaseAction = new BaseDatabaseAction();
        baseDatabaseAction.setDbControlFactory((DBControlFactory)dbControlFactory);
        this.checkCopy(baseDatabaseAction, (DBControlFactory)dbControlFactory);
    }

    private void checkCopy(BaseDatabaseAction baseDatabaseAction, DBControlFactory dbControlFactory) {
        DatabaseConfig dbConfig = baseDatabaseAction.getDbConfig();
        Assert.assertTrue((dbConfig != dbControlFactory.getCurrentControl().getInfo().getConnectionInfo() ? 1 : 0) != 0);
        Properties p1 = dbConfig.getProperties();
        Properties p2 = dbControlFactory.getCurrentControl().getInfo().getConnectionInfo().getProperties();
        Assert.assertTrue((boolean)p1.equals(p2));
        Assert.assertFalse((p1 == p2 ? 1 : 0) != 0);
    }

    @Test
    public void testTestDBConnectionAction() throws Exception {
        DBControlFactoryImpl dbControlFactory = new DBControlFactoryImpl(OUTPUT_DIR, TestDbControlFactory.SQL_SCRIPT_BASE_DIR);
        dbControlFactory.setCurrentControl(dbControlFactory.makeControl(this.getDBConfig()));
        TestDBConnectionAjaxAction testDBConnectionAjaxAction = new TestDBConnectionAjaxAction();
        testDBConnectionAjaxAction.setDbControlFactory((DBControlFactory)dbControlFactory);
        testDBConnectionAjaxAction.setThreadPool(this.threadPool);
        Assert.assertEquals((String)"DB Connection failed", (String)"success", (String)testDBConnectionAjaxAction.execute());
        DatabaseConfig dbConfig = testDBConnectionAjaxAction.getDbConfig();
        dbConfig.setUsername("fred");
        Assert.assertTrue((String)"DB Connection didn't fail", (boolean)testDBConnectionAjaxAction.execute().equals("no_db"));
        for (Object message : testDBConnectionAjaxAction.getActionErrors()) {
            System.out.println(message);
        }
        dbConfig.setUsername("sa");
        Assert.assertTrue((String)"DB Connection failed", (boolean)testDBConnectionAjaxAction.execute().equals("success"));
    }
}

