/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserTestHelper;
import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReviewBaseActionTest
extends UseTestSpringContextTestCase {
    protected EffectiveUserProviderImpl effectiveUserProvider;
    private CommentManager commentManager;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.commentManager = (CommentManager)SpringContext.getComponent(CommentManager.class, (String)"commentManager");
        UserActionManager.resetForTests();
        this.effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponent((String)"effectiveUserProvider");
    }

    @After
    public void tearDown() throws Exception {
        this.effectiveUserProvider.popEffectivePrincipal();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testCommentFilter() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        FecruUser ziggy = ModelUtils.makeAndSaveUser("ziggy");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)UserTestHelper.createPrincipal(review.getAuthor().getUsername()), review.getAuthor());
        Comment c1 = this.commentManager.createComment("test comment 1", review, review.getAuthor());
        review.addComment(c1);
        Comment c2 = this.commentManager.createComment("test comment 2", review, review.getAuthor());
        review.addComment(c2);
        Comment c3 = this.commentManager.createComment("test comment 3", review, ziggy);
        review.addComment(c3);
        Comment c4 = this.commentManager.createComment("test comment 4", review, review.getAuthor());
        review.addComment(c4);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewBaseAction rba = new ReviewBaseAction();
        rba.commentManager = this.commentManager;
        rba.setReviewManager((ReviewManager)this.reviewManager);
        rba.setEffectiveUserProvider((EffectiveUserProvider)this.effectiveUserProvider);
        rba.setReviewid(review.getId());
        Assert.assertEquals((long)4L, (long)rba.getViewableComments().size());
        c1.setDraft(true);
        Assert.assertEquals((long)4L, (long)rba.getViewableComments().size());
        c2.setDeleted(true);
        Assert.assertEquals((long)3L, (long)rba.getViewableComments().size());
        c3.setDraft(true);
        Assert.assertEquals((long)2L, (long)rba.getViewableComments().size());
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        CrucibleRevision crucibleRev1 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2225", (String)"d2225", (Date)new Date());
        CrucibleRevision crucibleRev2 = FileRevisionManager.createRevision((String)"svn", (String)"/a/fake/path.c", (String)"d2226", (String)"d2226", (Date)new Date());
        FileRevisionExtraInfo frx1 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev1, (Review)review);
        FileRevisionExtraInfo frx2 = FRXManager.createAndAddFRX((CrucibleRevision)crucibleRev2, (Review)review);
        FRXComment rcomment1 = FRXCommentManager.createAndAddFrxComment((Comment)c1, (FileRevisionExtraInfo)frx1);
        FRXComment rcomment2 = FRXCommentManager.createAndAddFrxComment((Comment)c2, (FileRevisionExtraInfo)frx2);
        FRXComment rcomment3 = FRXCommentManager.createAndAddFrxComment((Comment)c3, (FileRevisionExtraInfo)frx1);
        FRXComment rcomment4 = FRXCommentManager.createAndAddFrxComment((Comment)c4, (FileRevisionExtraInfo)frx2);
        Assert.assertEquals((long)2L, (long)rba.getFrxComments().size());
        Assert.assertTrue((boolean)rba.getFrxComments().contains(rcomment1));
        Assert.assertTrue((boolean)rba.getFrxComments().contains(rcomment4));
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        rcomment3.getComment().setDraft(false);
        Assert.assertEquals((long)3L, (long)rba.getFrxComments().size());
        Assert.assertTrue((boolean)rba.getFrxComments().contains(rcomment1));
        Assert.assertTrue((boolean)rba.getFrxComments().contains(rcomment3));
        Assert.assertTrue((boolean)rba.getFrxComments().contains(rcomment4));
        HibernateUtil.commitTransaction();
    }
}

