/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.RSSReviewQueryAction;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserManager;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RSSReviewQueryActionTest
extends UseTestSpringContextTestCase {
    private ModelUtils mu;
    private ReviewManager reviewManager;
    private UserManager userManager;

    @Before
    public void setUp() throws Exception {
        this.mu = new ModelUtils();
        this.mu.createBlankDB();
        UserActionManager.resetForTests();
        this.reviewManager = (ReviewManager)Mockito.mock(ReviewManager.class);
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)this.userManager.getUser(Mockito.anyString())).thenAnswer((Answer)new Answer<FecruUser>(){

            public FecruUser answer(InvocationOnMock invocation) throws Throwable {
                return new FecruUser((String)invocation.getArguments()[0]);
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.mu.destroyDB();
    }

    @Test
    public void testGetFilterNameCustomFilter() throws Exception {
        final FecruUser reviewer = this.userManager.getUser("peter");
        RSSReviewQueryAction action = new RSSReviewQueryAction();
        SpringContext.autowireObject((Object)action);
        action.setUserManager(this.userManager);
        action.setReviewManager(this.reviewManager);
        action.setFilter("custom");
        action.setComplete(Boolean.valueOf(true));
        action.setReviewer("peter");
        action.setTitle("sampleTitle");
        action.getFilteredReviewDetails();
        ((ReviewManager)Mockito.verify((Object)this.reviewManager)).getMatchingReviews((ReviewFilterDef)Mockito.argThat((Matcher)new ArgumentMatcher<ReviewFilterDef>(){

            public boolean matches(Object o) {
                if (!(o instanceof ReviewFilterDef)) {
                    return false;
                }
                ReviewFilterDef filter = (ReviewFilterDef)o;
                return filter.id == ReviewFilters.FilterKey.CUSTOM && filter.complete != false && filter.reviewer.equals((Object)reviewer);
            }
        }), (String)Mockito.eq((Object)"sampleTitle"));
    }

    @Test
    public void testGetFilterNameCustomFilterAllComplete() throws Exception {
        RSSReviewQueryAction action = new RSSReviewQueryAction();
        SpringContext.autowireObject((Object)action);
        action.setReviewManager(this.reviewManager);
        action.setFilter("custom");
        action.setComplete(Boolean.valueOf(true));
        action.setReviewer(null);
        action.setTitle("sampleTitle");
        action.getFilteredReviewDetails();
        ((ReviewManager)Mockito.verify((Object)this.reviewManager)).getMatchingReviews((ReviewFilterDef)Mockito.argThat((Matcher)new ArgumentMatcher<ReviewFilterDef>(){

            public boolean matches(Object o) {
                if (!(o instanceof ReviewFilterDef)) {
                    return false;
                }
                ReviewFilterDef filter = (ReviewFilterDef)o;
                return filter.id == ReviewFilters.FilterKey.CUSTOM && filter.allReviewersComplete != false && filter.complete == null && filter.reviewer == null;
            }
        }), (String)Mockito.eq((Object)"sampleTitle"));
    }
}

