/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.DownloadPatchAction;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.upload.UploadItem;
import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DownloadPatchActionTest {
    @Mock
    private PatchManager patchManager;
    @Mock
    private PermissionManager permissionManager;
    @Mock
    private PermissionScheme permissionScheme;
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    @Mock
    private Patch patch1;
    @Mock
    private Patch patch2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Review review1;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Review review2;
    @Mock
    private UploadItem uploadItem;
    private DownloadPatchAction action;
    private File tempFile;

    @Before
    public void setup() throws IOException {
        this.tempFile = File.createTempFile("temp", "file");
        this.action = new DownloadPatchAction(){
            {
                this.patchManager = DownloadPatchActionTest.this.patchManager;
                this.permissionManager = DownloadPatchActionTest.this.permissionManager;
                this.effectiveUserProvider = DownloadPatchActionTest.this.effectiveUserProvider;
            }
        };
        this.action.setTxTemplate((TxTemplate)new DummyTxTemplate());
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction((PermissionScheme)Matchers.any(PermissionScheme.class), (Principal)Matchers.any(Principal.class), (FecruUser)Matchers.any(FecruUser.class), Matchers.anyString(), (Review)Matchers.any(Review.class))).thenAnswer(arg -> arg.getArguments()[4].equals(this.review1));
        Mockito.when((Object)this.patchManager.getPatchById(Integer.valueOf(Matchers.eq((int)1)))).thenReturn((Object)this.patch1);
        Mockito.when((Object)this.patch1.getReview()).thenReturn((Object)this.review1);
        Mockito.when((Object)this.patchManager.getPatchById(Integer.valueOf(Matchers.eq((int)2)))).thenReturn((Object)this.patch2);
        Mockito.when((Object)this.patch2.getReview()).thenReturn((Object)this.review2);
        Mockito.when((Object)this.review1.getProject().getPermissionScheme()).thenReturn((Object)this.permissionScheme);
        Mockito.when((Object)this.patch1.getUploadItem()).thenReturn((Object)this.uploadItem);
        Mockito.when((Object)this.patch2.getUploadItem()).thenReturn((Object)this.uploadItem);
        Mockito.when((Object)this.uploadItem.getItemFile()).thenReturn((Object)this.tempFile);
    }

    @After
    public void teardown() {
        this.tempFile.delete();
    }

    @Test
    public void shouldRefuseDownloadPatchOfAnotherReview() {
        this.action.setActionPathInfo("/2");
        this.action.setReview(this.review1);
        String result = this.action.execute();
        Assert.assertEquals((Object)"error", (Object)result);
        Assert.assertThat((Object)this.action.getErrorDescription(), (Matcher)CoreMatchers.startsWith((String)"No such patch "));
    }

    @Test
    public void shouldRefuseDownloadPatchOfUnauthorizedReview() {
        this.action.setActionPathInfo("/2");
        this.action.setReview(this.review2);
        String result = this.action.execute();
        Assert.assertEquals((Object)"error", (Object)result);
        Assert.assertThat((Object)this.action.getErrorDescription(), (Matcher)CoreMatchers.startsWith((String)"Unable to find requested review "));
    }

    @Test
    public void shouldAllowDownloadPatchOfAuthorizedReview() {
        this.action.setActionPathInfo("/1");
        this.action.setReview(this.review1);
        String result = this.action.execute();
        Assert.assertEquals((Object)"success", (Object)result);
        Assert.assertNotNull((Object)this.action.getInputStream());
    }
}

