/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.parsers.PluginDescriptorReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public final class PluginInformationReader {
    static final String PLUGIN_INFO = "plugin-info";
    static final String DEFAULT_SCAN_FOLDER = "META-INF/atlassian";
    private final Option<Element> pluginInfo;
    private final Set<Application> applications;
    private final int pluginsVersion;

    PluginInformationReader(Option<Element> pluginInfo, Set<Application> applications, int pluginsVersion) {
        this.pluginsVersion = pluginsVersion;
        this.pluginInfo = (Option)Preconditions.checkNotNull(pluginInfo);
        this.applications = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(applications)));
    }

    public Option<String> getDescription() {
        return this.getDescriptionElement().map((Function)new Function<Element, String>(){

            public String apply(Element description) {
                return description.getTextTrim();
            }
        });
    }

    public Option<String> getDescriptionKey() {
        return this.getDescriptionElement().flatMap((Function)new Function<Element, Option<String>>(){

            public Option<String> apply(Element description) {
                return Option.option((Object)description.attributeValue("key"));
            }
        });
    }

    public Option<String> getVersion() {
        return this.childElement("version").map((Function)new Function<Element, String>(){

            public String apply(Element version) {
                return version.getTextTrim();
            }
        });
    }

    private Option<Element> childElement(String name) {
        return this.pluginInfo.flatMap((Function)new ChildElementFunction(name));
    }

    private Option<Iterable<Element>> childElements(String name) {
        return this.pluginInfo.map((Function)new ChildElementsFunction(name));
    }

    public Option<String> getVendorName() {
        return this.getVendorElement().flatMap((Function)new Function<Element, Option<String>>(){

            public Option<String> apply(Element vendor) {
                return Option.option((Object)vendor.attributeValue("name"));
            }
        });
    }

    public Option<String> getVendorUrl() {
        return this.getVendorElement().flatMap((Function)new Function<Element, Option<String>>(){

            public Option<String> apply(Element vendor) {
                return Option.option((Object)vendor.attributeValue("url"));
            }
        });
    }

    public Map<String, String> getParameters() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        for (Element param : this.getParamElements()) {
            params.put((Object)param.attribute("name").getData().toString(), (Object)param.getText());
        }
        return params.build();
    }

    public Option<Float> getMinVersion() {
        return this.getApplicationVersionElement().flatMap((Function)new GetAttributeFunction("min")).map((Function)new ParseAttributeValueAsFloatFunction());
    }

    public Option<Float> getMaxVersion() {
        return this.getApplicationVersionElement().flatMap((Function)new GetAttributeFunction("max")).map((Function)new ParseAttributeValueAsFloatFunction());
    }

    public Option<Float> getMinJavaVersion() {
        return this.childElement("java-version").flatMap((Function)new GetAttributeFunction("min")).map((Function)new ParseAttributeValueAsFloatFunction());
    }

    public Map<String, Option<String>> getPermissions() {
        ImmutableMap.Builder permissions = ImmutableMap.builder();
        for (Element permission : this.getPermissionElements()) {
            permissions.put((Object)permission.getTextTrim(), (Object)Option.option((Object)permission.attributeValue("installation-mode")));
        }
        return permissions.build();
    }

    public boolean hasAllPermissions() {
        return this.getPermissions().isEmpty() && this.pluginsVersion < 3;
    }

    public Set<String> getPermissions(final InstallationMode installationMode) {
        return ImmutableSet.copyOf(Maps.filterValues(this.getPermissions(), (Predicate)new Predicate<Option<String>>(){

            public boolean apply(Option<String> input) {
                return (Boolean)input.flatMap((Function)new Function<String, Option<InstallationMode>>(){

                    public Option<InstallationMode> apply(String mode) {
                        return InstallationMode.of((String)mode);
                    }
                }).fold(Suppliers.alwaysTrue(), (Function)new Function<InstallationMode, Boolean>(){

                    public Boolean apply(InstallationMode input) {
                        return input.equals((Object)installationMode);
                    }
                });
            }
        }).keySet());
    }

    public Option<String> getStartup() {
        return this.childElement("startup").map((Function)new Function<Element, String>(){

            public String apply(Element element) {
                return element.getTextTrim();
            }
        });
    }

    public Iterable<String> getModuleScanFolders() {
        final LinkedHashSet scanFolders = Sets.newLinkedHashSet();
        return (Iterable)this.childElement("scan-modules").map((Function)new Function<Element, Iterable<Element>>(){

            public Iterable<Element> apply(@Nullable Element scanModules) {
                List<Element> elements = PluginDescriptorReader.elements(scanModules, "folder");
                if (elements.isEmpty()) {
                    scanFolders.add(PluginInformationReader.DEFAULT_SCAN_FOLDER);
                }
                return elements;
            }
        }).map((Function)new Function<Iterable<Element>, Iterable<String>>(){

            public Iterable<String> apply(@Nullable Iterable<Element> folders) {
                for (Element folder : folders) {
                    scanFolders.add(folder.getTextTrim());
                }
                return scanFolders;
            }
        }).getOrElse((Object)ImmutableSet.of());
    }

    private Iterable<Element> getPermissionElements() {
        return (Iterable)this.childElement("permissions").map((Function)new Function<Element, Iterable<Element>>(){

            public Iterable<Element> apply(Element permissions) {
                return PluginDescriptorReader.elements(permissions, "permission");
            }
        }).map((Function)new Function<Iterable<Element>, Iterable<Element>>(){

            public Iterable<Element> apply(@Nullable Iterable<Element> input) {
                return Iterables.filter(input, (Predicate)new ElementWithForApplicationsPredicate(PluginInformationReader.this.applications));
            }
        }).map((Function)new Function<Iterable<Element>, Iterable<Element>>(){

            public Iterable<Element> apply(@Nullable Iterable<Element> input) {
                return Iterables.filter(input, (Predicate)new Predicate<Element>(){

                    public boolean apply(Element p) {
                        return StringUtils.isNotBlank((String)p.getTextTrim());
                    }
                });
            }
        }).getOrElse((Object)ImmutableList.of());
    }

    private Option<Element> getApplicationVersionElement() {
        return this.childElement("application-version");
    }

    private Iterable<Element> getParamElements() {
        return (Iterable)this.childElements("param").map((Function)new Function<Iterable<Element>, Iterable<Element>>(){

            public Iterable<Element> apply(Iterable<Element> input) {
                return Iterables.filter(input, (Predicate)new Predicate<Element>(){

                    public boolean apply(Element param) {
                        return param.attribute("name") != null;
                    }
                });
            }
        }).getOrElse((Object)ImmutableList.of());
    }

    private Option<Element> getVendorElement() {
        return this.childElement("vendor");
    }

    private Option<Element> getDescriptionElement() {
        return this.childElement("description");
    }

    private static final class ChildElementsFunction
    implements Function<Element, Iterable<Element>> {
        private final String name;

        public ChildElementsFunction(String name) {
            this.name = name;
        }

        public Iterable<Element> apply(Element el) {
            return PluginDescriptorReader.elements(el, this.name);
        }
    }

    private static final class ChildElementFunction
    implements Function<Element, Option<Element>> {
        private final String name;

        public ChildElementFunction(String name) {
            this.name = name;
        }

        public Option<Element> apply(Element el) {
            return Option.option((Object)el.element(this.name));
        }
    }

    private static final class ElementWithForApplicationsPredicate
    implements Predicate<Element> {
        private final Set<Application> applications;

        private ElementWithForApplicationsPredicate(Set<Application> applications) {
            this.applications = (Set)Preconditions.checkNotNull(applications);
        }

        public boolean apply(Element el) {
            String appName = el.attributeValue("application");
            return appName == null || Iterables.any(this.applications, (Predicate)new ApplicationWithNamePredicate(appName));
        }
    }

    private static final class ApplicationWithNamePredicate
    implements Predicate<Application> {
        @Nullable
        private final String name;

        public ApplicationWithNamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(Application app) {
            return app.getKey().equals(this.name);
        }
    }

    private static final class GetAttributeFunction
    implements Function<Element, Option<Attribute>> {
        private final String name;

        private GetAttributeFunction(String name) {
            this.name = name;
        }

        public Option<Attribute> apply(Element applicationVersion) {
            return Option.option((Object)applicationVersion.attribute(this.name));
        }
    }

    private static final class ParseAttributeValueAsFloatFunction
    implements Function<Attribute, Float> {
        private ParseAttributeValueAsFloatFunction() {
        }

        public Float apply(Attribute attr) {
            return Float.valueOf(Float.parseFloat(attr.getValue()));
        }
    }
}

