/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.Plugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PluginsInEnableOrder {
    final List<Plugin> sortedList = new ArrayList<Plugin>();

    public PluginsInEnableOrder(Collection<Plugin> pluginsToEnable, Map<String, Plugin> pluginKeyToPlugin) {
        HashSet<Plugin> visited = new HashSet<Plugin>();
        for (Plugin plugin : pluginsToEnable) {
            this.sortPluginForEnable(plugin, visited, pluginsToEnable, pluginKeyToPlugin);
        }
    }

    private void sortPluginForEnable(Plugin currentPlugin, Set<Plugin> visited, Collection<Plugin> allowedPlugins, Map<String, Plugin> pluginKeyToPlugin) {
        if (!visited.add(currentPlugin)) {
            return;
        }
        for (String key : currentPlugin.getDependencies().getAll()) {
            Plugin requiredPlugin = pluginKeyToPlugin.get(key);
            if (null == requiredPlugin) continue;
            this.sortPluginForEnable(requiredPlugin, visited, allowedPlugins, pluginKeyToPlugin);
        }
        if (allowedPlugins.contains(currentPlugin)) {
            this.sortedList.add(currentPlugin);
        }
    }

    public List<Plugin> get() {
        return Collections.unmodifiableList(this.sortedList);
    }
}

