/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.cache.ConcurrentCacheFactory;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.manager.ForwardingPluginAccessor;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class EnabledModuleCachingPluginAccessor
extends ForwardingPluginAccessor
implements PluginAccessor {
    private final PluginEventManager pluginEventManager;
    private final LoadingCache<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> cache;

    public EnabledModuleCachingPluginAccessor(PluginAccessor delegate, PluginEventManager pluginEventManager) {
        super(delegate);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.pluginEventManager.register((Object)this);
        this.cache = new DefaultPluginModuleTrackerCacheFactory().createCache();
    }

    public EnabledModuleCachingPluginAccessor(PluginAccessor delegate, PluginEventManager pluginEventManager, ConcurrentCacheFactory<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> pluginModuleTrackerCacheFactory) {
        super(delegate);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.pluginEventManager.register((Object)this);
        this.cache = pluginModuleTrackerCacheFactory.createCache();
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        return ImmutableList.copyOf(this.descriptors(descriptorClazz));
    }

    @PluginEventListener
    public void onPluginDisable(PluginDisabledEvent event) {
        this.cache.invalidateAll();
    }

    <D> Iterable<D> descriptors(Class<D> moduleDescriptorClass) {
        PluginModuleTracker tracker = (PluginModuleTracker)this.cache.getUnchecked(moduleDescriptorClass);
        return tracker.getModuleDescriptors();
    }

    private static class PluginModuleTrackerRemovalListener
    implements RemovalListener<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> {
        private PluginModuleTrackerRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> notification) {
            PluginModuleTracker tracker = (PluginModuleTracker)notification.getValue();
            if (tracker != null) {
                tracker.close();
            }
        }
    }

    private class PluginModuleTrackerFactory
    implements Function<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> {
        private PluginModuleTrackerFactory() {
        }

        public PluginModuleTracker<Object, ModuleDescriptor<Object>> apply(Class<ModuleDescriptor<Object>> moduleDescriptorClass) {
            return DefaultPluginModuleTracker.create(EnabledModuleCachingPluginAccessor.this.delegate, EnabledModuleCachingPluginAccessor.this.pluginEventManager, moduleDescriptorClass);
        }
    }

    private class DefaultPluginModuleTrackerCacheFactory
    implements ConcurrentCacheFactory<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> {
        private DefaultPluginModuleTrackerCacheFactory() {
        }

        @Override
        public LoadingCache<Class<ModuleDescriptor<Object>>, PluginModuleTracker<Object, ModuleDescriptor<Object>>> createCache() {
            return CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).removalListener((RemovalListener)new PluginModuleTrackerRemovalListener()).build(CacheLoader.from((Function)new PluginModuleTrackerFactory()));
        }
    }
}

