/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.webfragments;

import java.util.Map;
import java.util.stream.Collectors;

public class WebItemData {
    private final String url;
    private final String moduleKey;
    private final String linkText;
    private final String tooltip;
    private final String iconUrl;
    private final int iconWidth;
    private final int iconHeight;
    private final String styleClass;
    private final Map<String, String> params;
    public static final String DATA_PARAM_PREFIX = "data.";

    public WebItemData(String url, String moduleKey, String linkText, String tooltip, String iconUrl, int iconWidth, int iconHeight, String styleClass, Map<String, String> params) {
        this.url = url;
        this.moduleKey = moduleKey;
        this.linkText = linkText;
        this.tooltip = tooltip;
        this.iconUrl = iconUrl;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.styleClass = styleClass;
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public boolean getHasIcon() {
        return this.iconUrl != null;
    }

    public boolean getHasTooltip() {
        return this.tooltip != null;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getModuleKeyAsId() {
        return this.moduleKey.replace('.', '_').replace(':', '-');
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getDataAttributes() {
        return this.params.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(DATA_PARAM_PREFIX)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(DATA_PARAM_PREFIX.length()), entry -> (String)entry.getValue()));
    }
}

