/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.webfragments;

import com.atlassian.fisheye.plugin.web.helpers.DefaultHelper;
import com.atlassian.fisheye.plugin.web.helpers.DefaultHelperFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.webfragments.InjectableWebFragmentDataFactory;
import com.cenqua.fisheye.web.webfragments.WebFragmentDataFactory;
import com.cenqua.fisheye.web.webfragments.WebItemData;
import com.cenqua.fisheye.web.webfragments.WebSectionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="injectableWebFragmentDataFactory")
@AvailableToPlugins
public class DefaultInjectableWebFragmentDataFactory
implements InjectableWebFragmentDataFactory {
    private final WebInterfaceManager webInterfaceManager;
    private final DefaultHelperFactory helperFactory;

    @Autowired
    public DefaultInjectableWebFragmentDataFactory(WebInterfaceManager webInterfaceManager, DefaultHelperFactory helperFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.helperFactory = helperFactory;
    }

    @Override
    public List<WebItemData> getWebItems(HttpServletRequest request, String location) {
        return this.getWebItems(request, location, this.getHelperFactory().forRequest(request));
    }

    @Override
    public List<WebItemData> getWebItemsForRepo(HttpServletRequest request, String location, String path) {
        return StringUtils.isNotEmpty((String)path) ? this.getWebItems(request, location, this.getHelperFactory().forRepo(request, path)) : Collections.emptyList();
    }

    @Override
    public List<WebItemData> getWebItemsForChangeset(HttpServletRequest request, String location, String repoPath, String csid) {
        return this.getWebItems(request, location, this.getHelperFactory().forChangeset(request, repoPath, csid));
    }

    @Override
    public List<WebItemData> getWebItemsForRevision(HttpServletRequest request, String location, String repo, String csid, String filepath, String rev) {
        return this.getWebItems(request, location, this.getHelperFactory().forRevision(request, repo, csid, filepath, rev));
    }

    @Override
    public List<WebItemData> getWebItemsForProject(HttpServletRequest request, String location, String projectKey) {
        return this.getWebItems(request, location, this.getHelperFactory().forProject(request, projectKey));
    }

    @Override
    public List<WebItemData> getWebItemsForReview(HttpServletRequest request, String location, String reviewPermId) {
        return this.getWebItems(request, location, this.getHelperFactory().forReview(request, reviewPermId));
    }

    @Override
    public List<WebItemData> getWebItemsForReviewComment(HttpServletRequest request, String location, String reviewPermId, String commentPermId) {
        return this.getWebItems(request, location, this.getHelperFactory().forReviewComment(request, reviewPermId, commentPermId));
    }

    @Override
    public List<String> getWebPanelsForReviewComment(HttpServletRequest request, HttpServletResponse response, String location, String reviewPermId, String commentPermId) {
        return this.getWebPanels(request, response, location, this.getHelperFactory().forReviewComment(request, reviewPermId, commentPermId));
    }

    @Override
    public List<WebItemData> getWebItemsForReviewItemComment(HttpServletRequest request, String location, String reviewPermId, String itemPermId, String commentPermId) {
        return this.getWebItems(request, location, this.getHelperFactory().forReviewItemComment(request, reviewPermId, itemPermId, commentPermId));
    }

    @Override
    public List<WebItemData> getWebItemsForReviewItem(HttpServletRequest request, String location, String reviewPermId, String itemPermaId) {
        return this.getWebItems(request, location, this.getHelperFactory().forReviewItem(request, reviewPermId, itemPermaId));
    }

    @Override
    public List<WebItemData> getWebItemsForReviewParticipant(HttpServletRequest request, String location, String reviewPermId, String participantName) {
        return this.getWebItems(request, location, this.getHelperFactory().forReviewParticipant(request, reviewPermId, participantName));
    }

    private List<WebItemData> getWebItems(HttpServletRequest request, String location, DefaultHelper helper) {
        ArrayList<WebItemData> items = new ArrayList<WebItemData>();
        HashMap<String, DefaultHelper> context = new HashMap<String, DefaultHelper>();
        context.put("helper", helper);
        for (WebItemModuleDescriptor wimd : this.getWebInterfaceManager().getDisplayableItems(location, context)) {
            items.add(new WebItemData(wimd.getLink() == null ? null : wimd.getLink().getDisplayableUrl(request, context), wimd.getCompleteKey(), wimd.getWebLabel().getDisplayableLabel(request, context), wimd.getTooltip() == null ? null : wimd.getTooltip().getDisplayableLabel(request, context), wimd.getIcon() == null ? null : wimd.getIcon().getUrl().getDisplayableUrl(request, context), wimd.getIcon() == null ? 0 : wimd.getIcon().getWidth(), wimd.getIcon() == null ? 0 : wimd.getIcon().getHeight(), wimd.getStyleClass(), wimd.getParams()));
        }
        return items;
    }

    @Override
    public List<String> getWebPanels(HttpServletRequest request, HttpServletResponse response, String location) {
        return this.getWebPanels(request, response, location, this.getHelperFactory().forRequest(request));
    }

    @Override
    public List<String> getWebPanelsForRepo(HttpServletRequest request, HttpServletResponse response, String location, String path) {
        return StringUtils.isNotEmpty((String)path) ? this.getWebPanels(request, response, location, this.getHelperFactory().forRepo(request, path)) : Collections.emptyList();
    }

    @Override
    public List<String> getWebPanelsForChangeset(HttpServletRequest request, HttpServletResponse response, String location, String repoPath, String csid) {
        return this.getWebPanels(request, response, location, this.getHelperFactory().forChangeset(request, repoPath, csid));
    }

    @Override
    public List<String> getWebPanelsForReview(HttpServletRequest request, HttpServletResponse response, String location, String reviewKey) {
        return this.getWebPanels(request, response, location, this.getHelperFactory().forReview(request, reviewKey));
    }

    private List<String> getWebPanels(HttpServletRequest request, HttpServletResponse response, String location, DefaultHelper helper) {
        ArrayList<String> items = new ArrayList<String>();
        HashMap<String, DefaultHelper> context = new HashMap<String, DefaultHelper>();
        context.put("helper", helper);
        context.put("request", (DefaultHelper)request);
        context.put("response", (DefaultHelper)response);
        for (WebPanel wp : this.getWebInterfaceManager().getDisplayableWebPanels(location, context)) {
            try {
                items.add(wp.getHtml(context));
            }
            catch (Exception t2) {
                Logs.APP_LOG.warn((Object)("Error getting html for web panel: " + wp + " at location: " + location), (Throwable)t2);
            }
        }
        return items;
    }

    @Override
    public <T> List<T> mapWebPanelDescriptorsForRepo(HttpServletRequest request, String path, String location, WebFragmentDataFactory.ContextFunction<WebPanelModuleDescriptor, T> f2) {
        return this.mapWebPanelDescriptorsWithHelper(request, location, f2, this.getHelperFactory().forRepo(request, path));
    }

    @Override
    public <T> List<T> mapWebPanelDescriptors(HttpServletRequest request, String location, WebFragmentDataFactory.ContextFunction<WebPanelModuleDescriptor, T> f2) {
        return this.mapWebPanelDescriptorsWithHelper(request, location, f2, this.getHelperFactory().forRequest(request));
    }

    private <T> List<T> mapWebPanelDescriptorsWithHelper(HttpServletRequest request, String location, WebFragmentDataFactory.ContextFunction<WebPanelModuleDescriptor, T> f2, DefaultHelper helper) {
        ArrayList<T> items = new ArrayList<T>();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("helper", helper);
        context.put("request", request);
        for (WebPanelModuleDescriptor wp : this.getWebInterfaceManager().getDisplayableWebPanelDescriptors(location, context)) {
            try {
                items.add(f2.apply(wp, context));
            }
            catch (Exception t2) {
                Logs.APP_LOG.error((Object)("Error mapping web panel: " + wp + " at location: " + location), (Throwable)t2);
                items.add(f2.error(wp, t2));
            }
        }
        return items;
    }

    @Override
    public List<WebSectionData> getWebSectionsForRepo(HttpServletRequest request, String location, String path) {
        return this.getWebSections(request, location, this.getHelperFactory().forRepo(request, path), false);
    }

    @Override
    public List<WebSectionData> getWebSections(HttpServletRequest request, String location) {
        return this.getWebSections(request, location, false);
    }

    @Override
    public List<WebSectionData> getWebSections(HttpServletRequest request, String location, boolean includeItems) {
        return this.getWebSections(request, location, this.getHelperFactory().forRequest(request), includeItems);
    }

    private List<WebSectionData> getWebSections(HttpServletRequest request, String location, DefaultHelper helper, boolean includeItems) {
        ArrayList<WebSectionData> sections = new ArrayList<WebSectionData>();
        HashMap<String, DefaultHelper> context = new HashMap<String, DefaultHelper>();
        context.put("helper", helper);
        for (WebSectionModuleDescriptor wsmd : this.getWebInterfaceManager().getDisplayableSections(location, new HashMap())) {
            sections.add(new WebSectionData(wsmd.getName(), wsmd.getCompleteKey(), wsmd.getLocation(), wsmd.getWebLabel().getDisplayableLabel(request, context), includeItems ? this.getWebItems(request, location + "/" + wsmd.getName()) : Collections.emptyList()));
        }
        return sections;
    }

    private WebInterfaceManager getWebInterfaceManager() {
        return this.webInterfaceManager;
    }

    private DefaultHelperFactory getHelperFactory() {
        return this.helperFactory;
    }
}

