/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.Validate;

public class WrappedRequest
extends HttpServletRequestWrapper {
    private Map<String, String[]> params;

    public WrappedRequest(HttpServletRequest request) {
        super(request);
    }

    public void setParameter(String name, String value) {
        Validate.notEmpty((String)name);
        Validate.notNull((Object)value);
        if (this.params == null) {
            this.params = new LinkedHashMap<String, String[]>();
        }
        this.params.put(name, new String[]{value});
    }

    public String getParameter(String name) {
        if (this.params == null) {
            return super.getParameter(name);
        }
        return this.params.containsKey(name) ? this.params.get(name)[0] : super.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.params == null) {
            return super.getParameterMap();
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(super.getParameterMap());
        result.putAll(this.params);
        return Collections.unmodifiableMap(result);
    }

    public Enumeration getParameterNames() {
        if (this.params == null) {
            return super.getParameterNames();
        }
        HashSet result = new HashSet(super.getParameterMap().keySet());
        result.addAll(this.params.keySet());
        return Collections.enumeration(result);
    }

    public String[] getParameterValues(String name) {
        if (this.params == null) {
            return super.getParameterValues(name);
        }
        return this.params.containsKey(name) ? this.params.get(name) : super.getParameterValues(name);
    }
}

