/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.tags.wiki.WikiTextRendererTag;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.io.StringWriter;
import java.io.Writer;

public class WikiMarkupFormatter {
    public String formatText(String wikiText, String repoName) {
        return this.formatText(wikiText, null, repoName, false, false, true);
    }

    public String formatText(String wikiText, Review review) {
        return this.formatText(wikiText, review, null, false, false, true);
    }

    public String formatText(String wikiText) {
        return this.formatText(wikiText, null, null, false, false, true);
    }

    private String formatText(String wikiText, Review review, String repoName, boolean plain, boolean replaceNewlinesWithSpaces, boolean replaceNewlinesWithBreaks) {
        Tag tag = this.makeTag(wikiText, review, repoName, plain, replaceNewlinesWithSpaces, replaceNewlinesWithBreaks);
        try {
            tag.doTag();
        }
        catch (Exception e2) {
            String errorMsg = "Error rendering wiki text in review [" + tag.getReview() + "]";
            Logs.APP_LOG.error((Object)errorMsg, (Throwable)e2);
            return errorMsg + ", see logs for details.";
        }
        return tag.writer.toString();
    }

    private Tag makeTag(String wikiText, Review review, String repoName, boolean plain, boolean replaceNewlinesWithSpaces, boolean replaceNewlinesWithBreaks) {
        Tag tag = new Tag(new StringWriter(wikiText.length()));
        tag.setPlain(plain);
        tag.setWikiText(wikiText);
        tag.setReplaceNewlinesWithBreaks(replaceNewlinesWithBreaks);
        tag.setReplaceNewlinesWithSpaces(replaceNewlinesWithSpaces);
        if (review != null) {
            tag.setReview(review);
            if (!Strings.isNullOrEmpty((String)review.getProject().getDefaultRepositoryNameIfFisheyeRepository())) {
                tag.setRepName(review.getProject().getDefaultRepositoryNameIfFisheyeRepository());
            }
        } else {
            tag.setRepName(repoName);
        }
        return tag;
    }

    private static class Tag
    extends WikiTextRendererTag {
        private final StringWriter writer;

        private Tag(StringWriter writer) {
            this.writer = writer;
        }

        @Override
        protected Writer getOut() {
            return this.writer;
        }
    }
}

