/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Formatter;

public class WayBackUrlEncoder {
    private static final CharSet NEEDS_ESCAPING = new CharOpenHashSet(new char[]{'@', '/', ',', '='});
    private static final char ESCAPE_CHAR = '@';

    public static String commandUrlEncode(String toencode) {
        StringBuilder encoded = null;
        Formatter f2 = null;
        for (int i2 = 0; i2 < toencode.length(); ++i2) {
            char current = toencode.charAt(i2);
            if (NEEDS_ESCAPING.contains(current)) {
                if (encoded == null) {
                    encoded = new StringBuilder(toencode.substring(0, i2));
                    f2 = new Formatter(encoded);
                }
                encoded.append('@');
                f2.format("%02x", current);
                continue;
            }
            if (encoded == null) continue;
            encoded.append(current);
        }
        if (f2 != null) {
            f2.close();
        }
        if (encoded != null) {
            toencode = encoded.toString();
        }
        toencode = ExpressionUtil.deprecatedUrlPathEncode(toencode);
        return toencode;
    }

    public static String commandUrlDecode(String str) {
        try {
            str = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.warn((Object)"UTF-8 encoding not supported");
        }
        if (str.indexOf(64) == -1) {
            return str;
        }
        StringBuilder decoded = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char current = str.charAt(i2);
            if (current == '@' && i2 + 2 < str.length()) {
                try {
                    if (decoded == null) {
                        decoded = new StringBuilder(str.substring(0, i2));
                    }
                    StringBuilder hex = new StringBuilder("0x");
                    hex.append(str.charAt(i2 + 1));
                    hex.append(str.charAt(i2 + 2));
                    decoded.append(Character.toChars(Integer.decode(hex.toString())));
                    i2 += 2;
                }
                catch (NumberFormatException e3) {
                    if (decoded == null) continue;
                    decoded.append(current);
                }
                continue;
            }
            if (decoded == null) continue;
            decoded.append(current);
        }
        return decoded.toString();
    }
}

