/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Strings;
import java.util.zip.CRC32;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionIdUtil {
    public static final String ASESSIONID_NAME = "ASESSIONID";

    public static String generateAtlassianSessionHash(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session == null) {
            return null;
        }
        String ASESSIONID = (String)session.getAttribute(ASESSIONID_NAME);
        if (ASESSIONID == null) {
            ASESSIONID = SessionIdUtil.generateNewASESSIONID(session);
        }
        return SessionIdUtil.getDigestEncodedValue(ASESSIONID);
    }

    private static String generateNewASESSIONID(HttpSession session) {
        String sessionId = session.getId();
        String ASESSIONID = SessionIdUtil.generateASESSIONID(sessionId);
        if (ASESSIONID == null) {
            if (Logs.isDebugMode()) {
                Logs.APP_LOG.debug((Object)("Session with id '" + sessionId + "' generated a null hash. Not setting ASESSIONID cookie or header."));
            }
            return null;
        }
        String sessionIdHex = SessionIdUtil.smartHexEncode(sessionId, StringUtil.getBytesInUTF8(sessionId));
        ASESSIONID = ASESSIONID + '-' + sessionIdHex;
        session.setAttribute(ASESSIONID_NAME, (Object)ASESSIONID);
        return ASESSIONID;
    }

    public static String generateASESSIONID(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        byte[] digest = HashUtils.getSha1Digest(sessionId);
        return SessionIdUtil.encode(digest);
    }

    private static String getDigestEncodedValue(String asessionId) {
        if (Strings.isNullOrEmpty((String)asessionId)) {
            return null;
        }
        int index = asessionId.lastIndexOf(45);
        if (index == -1 || index == 0) {
            return null;
        }
        return asessionId.substring(0, index);
    }

    private static String smartHexEncode(String sessionId, byte[] bytes) {
        boolean isAllHex = true;
        for (char c2 : sessionId.toCharArray()) {
            if (SessionIdUtil.isHex(c2)) continue;
            isAllHex = false;
            break;
        }
        if (isAllHex) {
            return sessionId;
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toHexString(aByte));
        }
        return sb.toString();
    }

    private static boolean isHex(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static String encode(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return Long.toString(crc32.getValue(), 36);
    }
}

