/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.opensymphony.webwork.ServletActionContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="xsrfTokenGenerator")
public class SalXsrfTokenGenerator
implements XsrfTokenGenerator {
    private final XsrfTokenAccessor tokenAccessor;
    private final XsrfTokenValidator tokenValidator;

    @Autowired
    public SalXsrfTokenGenerator(XsrfTokenAccessor tokenAccessor, XsrfTokenValidator tokenValidator) {
        this.tokenAccessor = tokenAccessor;
        this.tokenValidator = tokenValidator;
    }

    public String getToken(HttpServletRequest request, boolean create) {
        return this.tokenAccessor.getXsrfToken(request, ServletActionContext.getResponse(), create);
    }

    public String generateToken(HttpServletRequest request) {
        return this.getToken(request, true);
    }

    public String getXsrfTokenName() {
        return this.tokenValidator.getXsrfParameterName();
    }

    public boolean validateToken(HttpServletRequest request, String token) {
        return this.tokenValidator.validateFormEncodedToken(request);
    }
}

