/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SafeRedirectChecker {
    private final RootConfig rootConfig;

    @Autowired
    public SafeRedirectChecker(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    public boolean canRedirectTo(String redirectUri) {
        if (StringUtils.isNotEmpty((String)redirectUri)) {
            try {
                boolean safe;
                URI uri = new URI(redirectUri);
                URI siteUri = new URI(this.rootConfig.getSiteURL());
                boolean bl = safe = !uri.isAbsolute() || uri.getScheme().equals(siteUri.getScheme()) && uri.getHost().equals(siteUri.getHost()) && this.getPort(uri) == this.getPort(siteUri) && (uri.getPath().equals(siteUri.getPath()) || uri.getPath().startsWith(siteUri.getPath()) && uri.getPath().charAt(siteUri.getPath().length()) == '/');
                if (!safe) {
                    Logs.APP_LOG.info((Object)("URL '" + redirectUri + "' is not safe for redirection, doesn't match site url of '" + this.rootConfig.getSiteURL() + "'"));
                }
                return safe;
            }
            catch (URISyntaxException e2) {
                Logs.APP_LOG.debug((Object)("Bad syntax for redirect URI '" + redirectUri + "'"), (Throwable)e2);
                return false;
            }
        }
        return true;
    }

    private int getPort(URI uri) {
        int port = uri.getPort();
        if (port != -1) {
            return port;
        }
        if (uri.getScheme() != null && uri.getScheme().equals("http")) {
            return 80;
        }
        if (uri.getScheme() != null && uri.getScheme().equals("https")) {
            return 443;
        }
        Logs.APP_LOG.info((Object)("Don't know default port for URI '" + uri.toString() + "'"));
        return -1;
    }
}

