/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.atlassian.fecru.exception.RepositoryNotFoundException;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.BranchSelectorUtil;
import com.cenqua.fisheye.web.WaybackSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RepositoryUtil {
    private static BranchSelectorUtil branchSelectorUtil = new BranchSelectorUtil();

    public static List<RepositoryHandle> repositories(HttpServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(request);
        return RepositoryUtil.repositories(user);
    }

    public static List<RepositoryHandle> repositories(Principal principal) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        List<RepositoryHandle> handles = AppConfig.getsConfig().getRepositoryManager().getHandles();
        ArrayList<RepositoryHandle> accessibleHandles = new ArrayList<RepositoryHandle>();
        for (RepositoryHandle handle : handles) {
            if (!um.hasPermissionToAccess(principal, handle)) continue;
            accessibleHandles.add(handle);
        }
        return accessibleHandles;
    }

    public static Map<String, RepositoryHandle> mapRepositories(HttpServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(request);
        List<RepositoryHandle> handles = AppConfig.getsConfig().getRepositoryManager().getHandles();
        HashMap<String, RepositoryHandle> accessibleHandles = new HashMap<String, RepositoryHandle>();
        for (RepositoryHandle handle : handles) {
            if (!um.hasPermissionToAccess(user, handle)) continue;
            accessibleHandles.put(handle.getName(), handle);
        }
        return accessibleHandles;
    }

    public static List<String> getCommittersInRep(RepositoryHandle handle) throws DbException {
        List<String> results = new ArrayList<String>();
        if (handle.isRunning()) {
            try {
                results = handle.acquireEngine().getRevisionCache().findAuthors(Path.ROOT);
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.warn((Object)("Repository " + handle.getName() + " is not running."), (Throwable)((Object)e2));
            }
        }
        return results;
    }

    public static boolean hasPermission(Principal principal, String repName) {
        RepositoryHandle repHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(repName);
        if (repHandle == null) {
            throw new RepositoryNotFoundException("No such repository '" + repName + "'");
        }
        return RepositoryUtil.hasPermission(principal, repHandle);
    }

    public static boolean hasPermission(Principal principal, RepositoryHandle repHandle) {
        if (repHandle == null) {
            throw new IllegalArgumentException("repHandle cannot be null");
        }
        UserManager um = AppConfig.getsConfig().getUserManager();
        return um.hasPermissionToAccess(principal, repHandle);
    }

    public static String getRepoType(String repname, HttpServletRequest request) {
        RepositoryHandle repositoryHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
        if (repositoryHandle == null) {
            Logs.APP_LOG.warn((Object)"Call to RepositoryUtil.getRepoType with invalid repository name.");
        } else if (RepositoryUtil.isAllowedToAccess(request, repositoryHandle)) {
            RepositoryConfig repositoryConfig = repositoryHandle.getCfg();
            return repositoryConfig.getRepositoryType().toString();
        }
        return null;
    }

    public static ChangeSet getChangesetById(String rep, String csid, HttpServletRequest request) throws DbException {
        RepositoryHandle repositoryHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(rep);
        try {
            if (RepositoryUtil.isAllowedToAccess(request, repositoryHandle)) {
                return repositoryHandle.acquireEngine().getRevisionCache().getChangeSet(csid);
            }
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.warn((Object)("Request for changeset from non active repository " + rep));
        }
        return null;
    }

    public static FileRevision getRevision(String repname, String path, String revision, HttpServletRequest request) throws DbException {
        try {
            RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
            if (RepositoryUtil.isAllowedToAccess(request, rep)) {
                return rep.acquireEngine().getRevisionCache().getFileRevision(new RevInfoKey(new Path(path), revision));
            }
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.warn((Object)("Request for FileRevision " + revision + " in rep " + repname + " had problems accessing the database"));
        }
        return null;
    }

    public static FileRevision getRevision(String repname, int revId, HttpServletRequest request) throws DbException {
        return RepositoryUtil.getRevision(repname, revId, RepositoryUtil.getUserLogin(request));
    }

    public static FileRevision getRevision(String repname, int revId, UserLogin userLogin) throws DbException {
        try {
            RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
            if (RepositoryUtil.isAllowedToAccess(userLogin, rep)) {
                return rep.acquireEngine().getRevisionCache().getFileRevision(revId);
            }
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.warn((Object)("Request for FileRevision " + revId + " in rep " + repname + " had problems accessing the database"));
        }
        return null;
    }

    public static String getRepositoryFromPath(Path path) {
        return path.getComponent(0);
    }

    private static boolean isAllowedToAccess(HttpServletRequest request, RepositoryHandle rep) {
        return RepositoryUtil.isAllowedToAccess(RepositoryUtil.getUserLogin(request), rep);
    }

    private static boolean isAllowedToAccess(UserLogin user, RepositoryHandle rep) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        return um.hasPermissionToAccess(user, rep);
    }

    private static UserLogin getUserLogin(HttpServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        return um.getCurrentUser(request);
    }

    public static Set<Path> getPhysicalPaths(Path localPath, WaybackSpec waybackSpec, RepositoryEngine engine) throws IOException, DbException {
        return branchSelectorUtil.getPhysicalPaths(localPath, waybackSpec, engine);
    }

    public static String getPhysicalPathUrl(Path localPath, WaybackSpec waybackSpec, RepositoryEngine engine, String repname, String queryString) throws IOException, DbException {
        return branchSelectorUtil.getPhysicalPathUrl(localPath, waybackSpec, engine, repname, queryString);
    }
}

