/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.factory.descriptor.ComponentModuleDescriptor;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArraySet;

public class PluginModuleInstanceTracker<T> {
    private final DefaultPluginModuleTracker<T, ModuleDescriptor<T>> moduleTracker;
    private final Class<T> moduleClass;
    private final CopyOnWriteArraySet<ModuleDescriptor<T>> moduleDescriptors = new CopyOnWriteArraySet();
    private final Function<? super ModuleDescriptor<T>, ? extends T> MODULE_DESCRIPTOR_TO_MODULE = new Function<ModuleDescriptor<T>, T>(){

        public T apply(ModuleDescriptor<T> input) {
            return input.getModule();
        }
    };

    public PluginModuleInstanceTracker(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, Class<T> moduleClass) {
        this.moduleClass = moduleClass;
        this.moduleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, ComponentModuleDescriptor.class, (PluginModuleTracker.Customizer)new ModuleTrackerCustomizer());
    }

    public T getModule() {
        return this.maybeGetModule().orElseThrow(() -> new IllegalStateException("Cannot find module of class " + this.moduleClass));
    }

    public Optional<T> maybeGetModule() {
        Iterator<ModuleDescriptor<T>> it = this.moduleDescriptors.iterator();
        if (it.hasNext()) {
            return Optional.of(it.next().getModule());
        }
        return Optional.empty();
    }

    public Iterable<T> getModules() {
        return Iterables.transform((Iterable)ImmutableList.copyOf(this.moduleDescriptors), this.MODULE_DESCRIPTOR_TO_MODULE);
    }

    class ModuleTrackerCustomizer
    implements PluginModuleTracker.Customizer<T, ModuleDescriptor<T>> {
        ModuleTrackerCustomizer() {
        }

        public ModuleDescriptor<T> adding(ModuleDescriptor<T> descriptor) {
            if (PluginModuleInstanceTracker.this.moduleClass.isAssignableFrom(descriptor.getModuleClass())) {
                PluginModuleInstanceTracker.this.moduleDescriptors.add(descriptor);
                descriptor.getModule();
                return descriptor;
            }
            return null;
        }

        public void removed(ModuleDescriptor<T> descriptor) {
            PluginModuleInstanceTracker.this.moduleDescriptors.remove(descriptor);
        }
    }
}

