/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.vis.ChartDimension;
import javax.servlet.http.HttpServletRequest;

public class ParamUtils {
    public static int parseInt(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static Integer parseInteger(String str, Integer def) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static Interval parseSpan(String str, Interval def) {
        if (str == null) {
            return def;
        }
        try {
            return new Interval(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static ChartDimension getDimension(HttpServletRequest req, ChartDimension defaultDim) {
        return new ChartDimension(ChartDimension.restrictDimension(ParamUtils.getParam(req, "w", defaultDim.getWidth())), ChartDimension.restrictDimension(ParamUtils.getParam(req, "h", defaultDim.getHeight())));
    }

    private static int getParam(HttpServletRequest req, String s2, int defaultInt) {
        return ParamUtils.parseInt(req.getParameter(s2), defaultInt);
    }

    public static boolean isInt(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }
}

