/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;

public class LinkerFormatter
extends AbstractRegionListTag {
    private final Linker linker;
    private final StringWriter out;

    public LinkerFormatter(Linker linker) {
        this.linker = linker;
        this.out = new StringWriter();
    }

    public String format(String text) {
        RegionList regions = new RegionList();
        regions.add(new Region(0, text.length(), Collections.singletonMap("findlinks", "true")));
        this.linker.insertLinks(text, regions);
        try {
            this.outputRegion(text, regions, 0, text.length());
            return this.getOut().toString();
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    protected Writer getOut() {
        return this.out;
    }

    @Override
    protected String getSpanClass(Region region) {
        return this.getStandardSpanClass(region, true);
    }
}

