/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.logging.Logs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.BitSet;

public class FishEyeURLEncoder {
    private static final String UTF8 = "UTF-8";
    private static final BitSet URI_UNRESERVED_CHARS;
    private static final BitSet LAZY_IGNORE_CHARS;
    private static final int caseDiff = 32;

    private FishEyeURLEncoder() {
    }

    @Deprecated
    public static String pathEncode(String s2) {
        try {
            return s2 == null ? null : FishEyeURLEncoder.encodeSome(s2, LAZY_IGNORE_CHARS);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException("UTF-8 encoding is missing", e2);
        }
    }

    public static String uriEncode(String s2) {
        try {
            return s2 == null ? null : FishEyeURLEncoder.encodeSome(s2, URI_UNRESERVED_CHARS);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException("UTF-8 encoding is missing", e2);
        }
    }

    public static String encodeAll(String s2) {
        try {
            return FishEyeURLEncoder.encodeSome(s2, null);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException("UTF-8 encoding is missing", e2);
        }
    }

    private static String encodeSome(String s2, BitSet dontNeedEncoding) throws UnsupportedEncodingException {
        if (s2 == null) {
            return "";
        }
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s2.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, UTF8);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (dontNeedEncoding != null && dontNeedEncoding.get(c2)) {
                out.append(c2);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d2;
                if (wroteUnencodedChar) {
                    writer = new OutputStreamWriter((OutputStream)buf, UTF8);
                    wroteUnencodedChar = false;
                }
                ((Writer)writer).write(c2);
                if (c2 >= '\ud800' && c2 <= '\udbff' && i2 + 1 < s2.length() && (d2 = s2.charAt(i2 + 1)) >= '\udc00' && d2 <= '\udfff') {
                    ((Writer)writer).write(d2);
                    ++i2;
                }
                ((Writer)writer).flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            byte[] ba2 = buf.toByteArray();
            for (int j2 = 0; j2 < ba2.length; ++j2) {
                out.append('%');
                char ch = Character.forDigit(ba2[j2] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba2[j2] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s2;
    }

    public static String decode(String s2) {
        try {
            return URLDecoder.decode(s2, UTF8);
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.debug((Object)("UTF-8 not supported." + e2));
            return URLDecoder.decode(s2);
        }
    }

    static {
        int i2;
        URI_UNRESERVED_CHARS = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            URI_UNRESERVED_CHARS.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            URI_UNRESERVED_CHARS.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            URI_UNRESERVED_CHARS.set(i2);
        }
        URI_UNRESERVED_CHARS.set(45);
        URI_UNRESERVED_CHARS.set(46);
        URI_UNRESERVED_CHARS.set(95);
        URI_UNRESERVED_CHARS.set(126);
        LAZY_IGNORE_CHARS = (BitSet)URI_UNRESERVED_CHARS.clone();
        LAZY_IGNORE_CHARS.set(47);
    }
}

