/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.themer;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.NaturalComparator;
import com.cenqua.fisheye.util.StringComparator;
import com.cenqua.fisheye.web.UrlHelper;
import com.cenqua.fisheye.web.el.ExtendedELContext;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringEscapeUtils;

public class TableSorterTag
extends TagSupport {
    private final Map mColumns = new HashMap();
    private Object mItems;
    private String mVar;
    private String mDefaultColumn;
    private String mSortParam;
    private String mBaseUrl;

    public void setBaseUrl(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    public void setItems(Object items) {
        this.mItems = items;
    }

    public void setVar(String var) {
        this.mVar = var;
    }

    public void setDefaultColumn(String defaultColumn) {
        this.mDefaultColumn = defaultColumn;
    }

    public void setSortParam(String sortColumn) {
        this.mSortParam = sortColumn;
    }

    public String getSortParam() {
        return this.mSortParam;
    }

    void addColumn(ColumnTag column) {
        String name = column.mName;
        this.mColumns.put(name, column);
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            ArrayList result;
            ArrayList items = ExpressionUtil.asList(this.mItems);
            if (items == null) {
                result = items;
            } else {
                Comparator comp = this.makeComparator();
                if (comp != null) {
                    result = new ArrayList(items);
                    Collections.sort(result, comp);
                } else {
                    result = items;
                }
            }
            this.pageContext.setAttribute(this.mVar, (Object)result);
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.warn((Object)"unexpected RT exception", (Throwable)e2);
        }
        return 6;
    }

    private Comparator makeComparator() {
        ColumnTag col;
        String colName = this.getSelectedColumnString();
        if (colName == null) {
            return null;
        }
        boolean invert = false;
        if (colName.startsWith("-")) {
            invert = true;
            colName = colName.substring(1);
        }
        if ((col = (ColumnTag)((Object)this.mColumns.get(colName))) == null) {
            Logs.APP_LOG.info((Object)("could not find column " + colName));
            return null;
        }
        final boolean reversed = col.mDefaultReverse ^ invert;
        String privateVarName = "currentTableCellF00Bar";
        final String exprString = "${currentTableCellF00Bar." + col.getExpressionString() + "}";
        final ValueExpression exp = ExpressionUtil.parseExpression(this.pageContext, exprString, Object.class);
        final Comparator orderer = col.getComparator();
        Comparator comp = new Comparator(){
            private ExtendedELContext ctx;
            {
                this.ctx = new ExtendedELContext(TableSorterTag.this.pageContext.getELContext());
            }

            public int compare(Object o1, Object o2) {
                Object a2 = this.eval(o1);
                Object b2 = this.eval(o2);
                int result = orderer.compare(a2, b2);
                if (reversed) {
                    result = -result;
                }
                return result;
            }

            private Object eval(Object o1) {
                try {
                    this.ctx.getVars().put("currentTableCellF00Bar", o1);
                    return exp.getValue((ELContext)this.ctx);
                }
                catch (RuntimeException e2) {
                    Logs.APP_LOG.warn((Object)("error sorting with " + exprString), (Throwable)e2);
                    return null;
                }
            }
        };
        return comp;
    }

    String getSelectedColumnString() {
        String colName = this.pageContext.getRequest().getParameter("^" + this.mSortParam);
        if (colName == null || colName.length() == 0) {
            colName = this.mDefaultColumn;
        }
        return colName;
    }

    public static class ColumnLink
    extends SimpleTagSupport {
        private String mName;

        public void setName(String name) {
            this.mName = name;
        }

        public void doTag() throws JspException, IOException {
            TableSorterTag parent = (TableSorterTag)ColumnLink.findAncestorWithClass((JspTag)this, TableSorterTag.class);
            if (parent == null) {
                throw new JspException("no matching TableSorter parent");
            }
            boolean inverted = false;
            String selectedName = parent.getSelectedColumnString();
            if (selectedName.startsWith("-")) {
                inverted = true;
                selectedName = selectedName.substring(1);
            }
            boolean selected = selectedName.equals(this.mName);
            JspWriter out = this.getJspContext().getOut();
            UrlHelper url = new UrlHelper();
            url.setEncodedUrl(parent.mBaseUrl);
            boolean asc = selected && !inverted;
            url.getParams().put("^" + parent.getSortParam(), (asc ? "-" : "") + this.mName);
            out.write("<a href=\"" + StringEscapeUtils.escapeHtml((String)url.toString()) + "\">");
            this.getJspBody().invoke((Writer)out);
            out.write("</a>");
            if (selected) {
                out.write(asc ? "&#171;" : "&#187;");
            }
        }
    }

    public static class ColumnTag
    extends TagSupport {
        String mExpr;
        String mName;
        boolean mDefaultReverse = false;
        private Comparator mComparator = NaturalComparator.INSTANCE;

        public void setExpr(String expr) {
            this.mExpr = expr;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public void setDefaultReverse(boolean defaultReverse) {
            this.mDefaultReverse = defaultReverse;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            if (ignoreCase) {
                this.mComparator = StringComparator.IGNORE_CASE_INSTANCE;
            }
        }

        Comparator getComparator() {
            return this.mComparator;
        }

        public int doEndTag() throws JspException {
            TableSorterTag parent = (TableSorterTag)ColumnTag.findAncestorWithClass((Tag)this, TableSorterTag.class);
            if (parent == null) {
                throw new JspException("no matching TableSorter parent");
            }
            parent.addColumn(this);
            return 6;
        }

        public String getExpressionString() {
            if (this.mExpr == null) {
                return this.mName;
            }
            return this.mExpr;
        }
    }
}

