/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.themer;

import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class CheckboxTag
extends SimpleTagSupport {
    private String mValue;
    private boolean mIsSelected = false;
    private String mName;
    private String mType = "checkbox";
    private boolean mDefaultChecked = false;

    public void setValue(String value) {
        this.mValue = value;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setIsSelected(boolean isSelected) {
        this.mIsSelected = isSelected;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.mDefaultChecked = defaultChecked;
    }

    public void doTag() throws JspException, IOException {
        PageContext ctx = (PageContext)this.getJspContext();
        JspWriter out = ctx.getOut();
        String value = this.mValue;
        String name = this.mName;
        boolean isSelect = this.mType.equalsIgnoreCase("option");
        if (isSelect) {
            out.write("<option");
        } else {
            out.write("<input type=\"" + this.mType + "\"");
            out.write(" name=\"" + name + "\"");
        }
        out.write(" value=\"" + this.encodeValue(value) + "\"");
        String id = name + "_" + this.encodeValue(value);
        out.write(" id=\"" + id + "\"");
        String[] params = ctx.getRequest().getParameterValues(name);
        if (this.mIsSelected) {
            if (isSelect) {
                out.write(" selected=\"selected\"");
            } else {
                out.write(" checked=\"checked\"");
            }
        }
        if (params != null) {
            for (String param : params) {
                if (!param.equals(value)) continue;
                if (isSelect) {
                    out.write(" selected");
                } else {
                    out.write(" checked");
                }
                break;
            }
        } else if (this.mDefaultChecked) {
            out.write(" checked");
        }
        out.write(">");
        JspFragment body = this.getJspBody();
        if (body != null) {
            if (isSelect) {
                body.invoke((Writer)out);
                out.write("</option>");
            } else {
                out.write("<label for=\"" + id + "\">");
                body.invoke((Writer)out);
                out.write("</label>");
            }
        }
    }

    private String encodeValue(String value) {
        return ExpressionUtil.escapeString(value);
    }
}

