/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.themer;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;

public class BriefCheckinCommentTag
extends AbstractRegionListTag {
    private WikiRenderer wikiRenderer;
    private LinkerService linkerService;
    private String comment;
    private int maxHeight = -1;
    private int maxCharacters = -1;
    private boolean wasTruncated = false;
    private String ellipses = "&#8230;";
    private boolean autoCommentFormatting = true;
    private String repname;
    private boolean asText;
    private Date commentDate;

    public BriefCheckinCommentTag() {
        this.setPrintFirstSpaceAsSpace(true);
    }

    public void setAutoCommentFormatting(boolean autoCommentFormatting) {
        this.autoCommentFormatting = autoCommentFormatting;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setLineSeparator(String lineSeparator) {
        this.setEol(lineSeparator);
    }

    public void setEllipses(String ellipses) {
        this.ellipses = ellipses;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setAsText(boolean asText) {
        this.asText = asText;
    }

    public Date getDate() {
        return this.commentDate;
    }

    public void setDate(Date mCommentDate) {
        this.commentDate = mCommentDate;
    }

    public void doTag() throws IOException {
        Writer out = this.getOut();
        if (this.comment.length() == 0) {
            if (this.autoCommentFormatting) {
                out.write("<em>no_comment</em>");
            } else {
                out.write("no_comment");
            }
        } else {
            this.renderCheckinComment(out);
        }
    }

    private void renderCheckinComment(Writer out) throws IOException {
        Timer t2 = new Timer("commit-msg-render");
        RegionList regions = new RegionList();
        RenderContext renderContext = null;
        if (this.autoCommentFormatting) {
            Linker linker;
            boolean isWiki;
            regions.add(new Region(0, this.comment.length(), Collections.singletonMap("findlinks", "true")));
            RepositoryConfig cfg = this.getRepositoryConfig();
            if (cfg != null) {
                isWiki = this.isWikiSyntax(cfg.getRepositoryTypeConfig());
                linker = this.getLinkerService().getRepositoryLinker(cfg.getName());
            } else {
                RootConfig rootConfig = AppConfig.getsConfig();
                isWiki = this.isWikiSyntax(rootConfig.getConfig().getRepositoryDefaults().getCommitMessageSyntax());
                linker = this.getLinkerService().getDefaultLinker();
            }
            renderContext = this.setupCommentFormatting(regions, linker, isWiki);
        }
        this.doOutput(out, regions, renderContext);
        t2.end();
    }

    private boolean isWikiSyntax(RepositoryType repositoryTypeConfig) {
        if (repositoryTypeConfig.isSetCommitMessageSyntax()) {
            return this.isWikiSyntax(repositoryTypeConfig.getCommitMessageSyntax());
        }
        return this.isWikiSyntax(AppConfig.getsConfig().getConfig().getRepositoryDefaults().getCommitMessageSyntax());
    }

    private boolean isWikiSyntax(CommitMessageSyntaxType commitMessage) {
        if (CommitMessageSyntaxType.Syntax.WIKI == commitMessage.getSyntax()) {
            if (commitMessage.getWikiSyntaxStartDate() != null && this.commentDate != null) {
                return commitMessage.getWikiSyntaxStartDate().getTime().before(this.commentDate);
            }
            return true;
        }
        return false;
    }

    private RenderContext setupCommentFormatting(RegionList regions, Linker linker, boolean wiki) {
        RenderContext renderContext = null;
        if (wiki) {
            renderContext = this.makeRenderContext(linker);
        } else {
            linker.insertLinks(this.comment, regions);
        }
        return renderContext;
    }

    private RenderContext makeRenderContext(Linker linker) {
        CrucibleRenderContext crucibleRenderContext = (CrucibleRenderContext)this.getWikiRenderer().setupRenderContextProperties((RenderContext)new CrucibleRenderContext(null, this.getSpace(), this.getEol(), this.getRepName(), linker, this.isAllowConsecutiveNewline()));
        if (!this.asText) {
            crucibleRenderContext.pushRenderMode(crucibleRenderContext.getRenderMode().and(RenderMode.ALL_WITH_NO_MACRO_ERRORS));
        } else {
            crucibleRenderContext.pushRenderMode(RenderMode.PHRASES_LINKS);
        }
        return crucibleRenderContext;
    }

    private void doOutput(Writer out, RegionList regions, RenderContext wikiRenderContext) throws IOException {
        String trimmedComment = this.trimToConstraint(this.comment);
        if (wikiRenderContext != null) {
            out.append(this.getWikiRenderer().render((CharSequence)trimmedComment, wikiRenderContext));
        } else {
            this.outputRegion(trimmedComment, regions, 0, trimmedComment.length());
        }
        if (this.wasTruncated) {
            out.write(this.ellipses);
        }
    }

    protected RepositoryConfig getRepositoryConfig() {
        RepositoryConfig config = (RepositoryConfig)this.getJspContext().findAttribute("RepositoryConfig");
        if (config == null && this.repname != null) {
            RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(this.repname);
            if (h2 == null) {
                Logs.APP_LOG.debug((Object)("Couldn't find repository " + this.repname + ", unable to construct linker"));
                return null;
            }
            return h2.getCfg();
        }
        return config;
    }

    private String trimToConstraint(String comment) throws IOException {
        if (this.maxHeight > 0) {
            String line;
            int nlines = 0;
            int end = 0;
            ReaderLineReader lines = new ReaderLineReader(new StringReader(this.comment));
            while (null != (line = lines.readLine())) {
                if (++nlines > this.maxHeight) {
                    comment = comment.substring(0, end);
                    this.wasTruncated = true;
                    break;
                }
                end += line.length();
            }
        }
        if (this.maxCharacters > 0 && comment.length() > this.maxCharacters) {
            comment = comment.substring(0, this.maxCharacters);
            this.wasTruncated = true;
        }
        if (this.wasTruncated) {
            comment = StringUtil.stripEOL(comment);
        }
        return comment;
    }

    @Override
    protected String getSpanClass(Region region) {
        return LinkerFactory.getPopupLinkSpanClass(region);
    }

    public void setRepName(String repname) {
        this.repname = repname;
    }

    public String getRepName() {
        return this.repname;
    }

    private LinkerService getLinkerService() {
        if (this.linkerService == null) {
            this.linkerService = (LinkerService)SpringContext.getComponent("linkerService");
        }
        return this.linkerService;
    }

    private WikiRenderer getWikiRenderer() {
        if (this.wikiRenderer == null) {
            this.wikiRenderer = (WikiRenderer)SpringContext.getComponent("crucibleWikiRenderer");
        }
        return this.wikiRenderer;
    }
}

