/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.tarball.TarballAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tarballer
extends TarballAction.AbstractBaller {
    private final File mTmpFile = Disposer.threadInstance().newDisposedTmpFile();
    private TarOutputStream mOut;

    public Tarballer(RevisionCache CRep, Path prefix) throws IOException {
        super(CRep, prefix);
    }

    @Override
    public void start(OutputStream os) {
        this.mOut = new TarOutputStream(os);
        this.mOut.setLongFileMode(2);
    }

    @Override
    public void done() throws IOException {
        this.mOut.finish();
        this.mOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(TarballAction.BallEntry entry, String vpath) throws IOException, RCSParser.ParseException, DbException {
        BufferedOutputStream out;
        block3: {
            out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.mTmpFile));
                if (entry.binary) {
                    this.mCRep.getBinaryRevision(entry.key, out);
                    break block3;
                }
                this.mCRep.getTextRevision(entry.key, out, null, entry.symrev);
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                throw throwable;
            }
        }
        IOHelper.close(out);
        TarEntry te = new TarEntry(vpath);
        te.setModTime(entry.date);
        te.setSize(this.mTmpFile.length());
        this.mOut.putNextEntry(te);
        IOHelper.copyStream(this.mTmpFile, (OutputStream)this.mOut);
        this.mOut.closeEntry();
    }
}

