/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.TarballConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.mime.BrowserUtils;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.tarball.Tarballer;
import com.cenqua.fisheye.web.tarball.ZipBaller;
import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarballAction
extends BaseAction {
    private static final String[] TARBALL_EXTENSIONS = new String[]{".zip", ".tar.gz", ".tgz", ".tar.bz", ".tbz", ".tar.bz2", ".tbz2"};
    private static final int MAX_FILE_NAME_LENGTH = 100;
    private static final String DEFAULT_TARBALL_FILE_NAME = "tarball";
    private RevisionCache mRep;
    private int mMaxFiles = 0;
    int mFileCount;

    @Override
    public long computeLastModified() {
        return this.computeRepositoryLastModified();
    }

    @Override
    public BaseAction handleRequest(BaseActionParams baseParams) throws ServletException, IOException, DbException {
        TarballConfig tbCfg;
        boolean isTarballEnabled;
        this.parseWaybackSpec();
        FishEyePathInfo pi = this.getPathInfo();
        RepositoryConfig cfg = pi.getRepository();
        this.mRep = pi.getEngine().getRevisionCache();
        Path path = pi.getLocalPath();
        if (this.hasBallExtension(path.getName())) {
            path = path.getParent();
        }
        boolean bl = isTarballEnabled = (tbCfg = cfg.getTarballConfig()).isEnabled() && !tbCfg.isExcluded(path);
        if (!isTarballEnabled) {
            throw new ServletException("tarballing disabled");
        }
        this.mMaxFiles = tbCfg.getMaxFileCount();
        try {
            GZIPOutputStream zout;
            AbstractBaller baller;
            String balltype = pi.getCommandParam(DEFAULT_TARBALL_FILE_NAME);
            if ("tgz".equals(balltype)) {
                this.setResponseHeaders("application/x-gzip", path, "tgz");
                baller = new Tarballer(this.mRep, path);
                zout = new GZIPOutputStream((OutputStream)this.getResponse().getOutputStream());
            } else if ("tbz2".equals(balltype)) {
                this.setResponseHeaders("application/x-bzip2", path, "tbz2");
                ServletOutputStream rout = this.getResponse().getOutputStream();
                rout.write(66);
                rout.write(90);
                zout = new CBZip2OutputStream((OutputStream)rout);
                baller = new Tarballer(this.mRep, path);
            } else {
                String contentType = BrowserUtils.isIE(this.getRequest()) ? "application/zip; charset=UTF-8" : "application/zip";
                this.setResponseHeaders(contentType, path, "zip");
                baller = new ZipBaller(this.mRep, path);
                zout = this.getResponse().getOutputStream();
            }
            baller.start(zout);
            this.getMatchingEntries(baller, path);
            baller.done();
            ((OutputStream)zout).close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"error creating tarball, aborting");
            throw new ServletException((Throwable)e2);
        }
        catch (RCSParser.ParseException e3) {
            Logs.APP_LOG.warn((Object)"error creating tarball, aborting");
            throw new ServletException((Throwable)e3);
        }
        return null;
    }

    private void setResponseHeaders(String contentType, Path path, String ext) {
        HttpServletResponse response = this.getResponse();
        response.setContentType(contentType);
        String fname = TarballAction.makeTarballFilename(path) + "." + ext;
        response.setHeader("Content-Disposition", "attachment; filename=" + fname);
    }

    public static boolean isTarballEnabled(RepositoryEngine engine, Path path) {
        return engine.getCfg().getTarballConfig().isEnabled() && !engine.getCfg().getTarballConfig().isExcluded(path);
    }

    public static String makeTarballFilename(Path path) {
        String name = path.getName();
        String ret = CharMatcher.inRange((char)'\u0000', (char)'\u007f').and(CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"-_."))).retainFrom((CharSequence)name);
        if (ret.isEmpty()) {
            return DEFAULT_TARBALL_FILE_NAME;
        }
        return ret.length() > 100 ? ret.substring(0, 100) : ret;
    }

    private void getMatchingEntries(AbstractBaller baller, Path dir) throws IOException, RCSParser.ParseException, DbException {
        this.mFileCount = 0;
        this.traverseDir(baller, dir);
    }

    private void traverseDir(AbstractBaller baller, Path dir) throws IOException, RCSParser.ParseException, DbException {
        Path[] dirs;
        Path[] files;
        if (this.tooManyFiles()) {
            Logs.APP_LOG.warn((Object)("tarball truncated, too many files: " + this.mFileCount));
            return;
        }
        for (Path file : files = this.mRep.listFiles(dir)) {
            if (this.tooManyFiles()) {
                Logs.APP_LOG.warn((Object)("tarball truncated, too many files: " + this.mFileCount));
                return;
            }
            this.checkFile(baller, file);
        }
        for (Path subdir : dirs = this.mRep.listDirs(dir)) {
            this.traverseDir(baller, subdir);
        }
    }

    private boolean tooManyFiles() {
        return this.mMaxFiles > 0 && this.mFileCount >= this.mMaxFiles;
    }

    private void checkFile(AbstractBaller baller, Path file) throws IOException, DbException, RCSParser.ParseException {
        FileHistory history = this.getRepositoryCache().getFileHistory(file);
        if (history == null) {
            return;
        }
        BallEntry entry = null;
        if (this.waybackSpec == null) {
            FileRevision info = history.getRevision(history.getHead());
            if (info != null && !info.isDead() && info.getPath().equals(file)) {
                entry = new BallEntry(info.getRevInfoKey(), info.getDate(), info.isBinary(), null);
            }
        } else {
            entry = this.bestMatch(history, this.waybackSpec);
        }
        if (entry != null) {
            baller.writeFile(entry);
            ++this.mFileCount;
        }
    }

    private BallEntry bestMatch(FileHistory history, WaybackSpec wb) {
        CommonFileRevisionInput best = null;
        for (FileRevision info : history.getRevisions()) {
            if (!wb.matchesRevision(info, false)) continue;
            if (best == null) {
                best = info;
                continue;
            }
            best = this.betterOf((FileRevision)best, info);
        }
        if (best != null && !best.isDead()) {
            String symname = null;
            if (wb.getBranch() != null) {
                symname = wb.getBranch();
            }
            if (wb.getTag() != null) {
                symname = wb.getTag();
            }
            return new BallEntry(best.getRevInfoKey(), best.getDate(), best.isBinary(), symname);
        }
        return null;
    }

    private FileRevision betterOf(FileRevision ia, FileRevision ib) {
        if (ia.getDate() > ib.getDate()) {
            return ia;
        }
        return ib;
    }

    private boolean hasBallExtension(String name) {
        for (String ext : TARBALL_EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    static abstract class AbstractBaller {
        protected final RevisionCache mCRep;
        protected final Path mPrefix;

        protected AbstractBaller(RevisionCache CRep, Path prefix) {
            this.mCRep = CRep;
            this.mPrefix = prefix;
        }

        public void writeFile(BallEntry entry) throws IOException, RCSParser.ParseException, DbException {
            int prefixLength = this.mPrefix.numComponents();
            Path fullpath = entry.key.getPath();
            Path pathnamepath = fullpath.trimFirst(prefixLength);
            this.writeFile(entry, pathnamepath.getPath());
        }

        public abstract void writeFile(BallEntry var1, String var2) throws IOException, RCSParser.ParseException, DbException;

        public abstract void start(OutputStream var1);

        public abstract void done() throws IOException;
    }

    static class BallEntry {
        final RevInfoKey key;
        final long date;
        final boolean binary;
        final String symrev;

        public BallEntry(RevInfoKey key, long date, boolean binary, String symrev) {
            this.key = key;
            this.date = date;
            this.binary = binary;
            this.symrev = symrev;
        }
    }
}

