/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ViewFileAction;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class WithRevisionDiffTag
extends TagSupport {
    private final Disposer disposer = new Disposer();
    private String var;
    private FileRevision toInfo;
    private FileRevision fromInfo;
    private String fromVar;
    private String repname;
    private String ignore;
    private int context;

    public WithRevisionDiffTag() {
        Disposer.threadInstance().disposeOnDispose(this.disposer);
        this.ignore = null;
        this.context = 3;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public void setVar(String s2) {
        this.var = s2;
    }

    public void setFromVar(String s2) {
        this.fromVar = s2;
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public void setToInfo(FileRevision toInfo) {
        this.toInfo = toInfo;
    }

    public void setContext(int context) {
        this.context = context;
    }

    public void release() {
        this.disposer.disposeAll();
        super.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doStartTag() throws JspException {
        RepositoryEngine engine;
        if (this.toInfo == null) {
            Logs.APP_LOG.warn((Object)"No revision given");
            return 0;
        }
        if (this.repname != null) {
            RepositoryHandle rh = AppConfig.getsConfig().getRepositoryManager().getRepository(this.repname);
            if (rh == null) {
                Logs.APP_LOG.info((Object)("could not find requested repository by name: " + this.repname));
                return 0;
            }
            try {
                engine = rh.acquireEngine();
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.info((Object)("could not acquire repository " + this.repname), (Throwable)((Object)e2));
                return 0;
            }
        } else {
            engine = (RepositoryEngine)this.pageContext.getRequest().getAttribute("RepositoryEngine");
        }
        if (engine == null) {
            throw new JspException("No Repository config for request");
        }
        RevisionCache<? extends ChangeSet> crep = engine.getRevisionCache();
        try {
            String kStr = this.pageContext.getRequest().getParameter("k");
            this.fromInfo = this.toInfo.getDiffRevision() != null ? crep.getFileRevision(this.toInfo.getDiffRevision()) : (!this.toInfo.getAncestors().isEmpty() ? crep.getFileRevision(this.toInfo.getAncestors().get(0)) : null);
            CookiePreferences prefs = PreferenceManager.getPreferences((HttpServletRequest)this.pageContext.getRequest());
            DiffOpts diffOpts = new DiffOpts(this.ignore);
            diffOpts.setSideBySide(prefs.isSideBySide());
            diffOpts.setSoftWrap(prefs.isSoftWrap());
            FileDiffExplorer diffs = ViewFileAction.diffRevisions(crep, this.fromInfo, this.toInfo, diffOpts, kStr);
            diffs.setContextLines(this.context);
            this.pageContext.setAttribute(this.var, (Object)diffs);
            if (this.fromVar == null) return 1;
            this.pageContext.setAttribute(this.fromVar, (Object)this.fromInfo);
            return 1;
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)"error getting diff", (Throwable)e3);
            return 0;
        }
        catch (IOException e4) {
            Logs.APP_LOG.warn((Object)"error getting diff", (Throwable)e4);
            return 0;
        }
    }

    public int doEndTag() throws JspException {
        this.disposer.disposeAll();
        return 6;
    }
}

