/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.jetbrains.annotations.NotNull;

public class ToJsonTag
extends SimpleTagSupport {
    private Object objectToSerialize;
    private static final ObjectMapper objectMapper = ToJsonTag.createObjectMapper();

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
        objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return objectMapper;
    }

    public void setObjectToSerialize(Object objectToSerialize) {
        this.objectToSerialize = objectToSerialize;
    }

    public void doTag() throws JspException, IOException {
        objectMapper.writeValue((Writer)new EscapeTagsWriter(this.getWriter()), this.objectToSerialize);
    }

    protected Writer getWriter() {
        return this.getJspContext().getOut();
    }

    private static class EscapeTagsWriter
    extends Writer {
        static final char TAG_START = '<';
        static final char TAG_END = '>';
        static final char[] ENCODED_START = "\\u003c".toCharArray();
        static final char[] ENCODED_END = "\\u003e".toCharArray();
        final Writer writer;

        public EscapeTagsWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
            block4: for (int i2 = off; i2 < off + len; ++i2) {
                char c2 = cbuf[i2];
                switch (c2) {
                    case '<': {
                        this.writer.write(ENCODED_START);
                        continue block4;
                    }
                    case '>': {
                        this.writer.write(ENCODED_END);
                        continue block4;
                    }
                    default: {
                        this.writer.write(c2);
                    }
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

