/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class RelativePathTag
extends SimpleTagSupport {
    private Path mPath = null;
    private Path mParent = Path.ROOT;
    private int mMaxLength = -1;
    private boolean caseSensitive = true;

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
    }

    public void setPath(Path aPath) {
        this.mPath = aPath != null ? aPath : Path.ROOT;
    }

    public void setPrefix(Path p2) {
        this.mParent = p2 != null ? (p2.equals(this.mPath) ? p2.getParent() : p2) : Path.ROOT;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void doTag() throws JspException, IOException {
        ExpressionUtil.escapeString(this.relativePathAsString(), (Writer)this.getJspContext().getOut());
    }

    public String relativePathAsString() {
        Path path = this.mPath.getRelativePath(this.mParent, this.caseSensitive);
        if (this.mMaxLength >= 0) {
            path = path.abbreviate(this.mMaxLength);
        }
        StringBuilder relativePath = new StringBuilder();
        if (this.mParent.isRoot()) {
            relativePath.append("/");
        } else if (!path.isAbove()) {
            relativePath.append("./");
        }
        return relativePath.append(path).toString();
    }
}

