/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.crucible.view.FRXDO;

public class NavListClassTag {
    public static String getNavListClass(FRXDO frxDO, Boolean canMarkCompleteOrUncomplete) {
        StringBuilder navListClass = new StringBuilder();
        if (frxDO != null) {
            if (frxDO.isDir()) {
                navListClass.append("filetype-folder");
            } else {
                navListClass.append("file filetype-").append(frxDO.getFePath().getExtension());
            }
            navListClass.append(" ").append(NavListClassTag.getFrxLinkClass(frxDO));
            if (canMarkCompleteOrUncomplete.booleanValue()) {
                if (frxDO.isComplete()) {
                    navListClass.append(" frx-complete");
                } else {
                    navListClass.append(" frx-incomplete");
                }
            }
        }
        return navListClass.toString();
    }

    public static String getFrxLinkClass(FRXDO frxDO) {
        return "frx-operation " + NavListClassTag.getFrxOperationClass(frxDO);
    }

    private static String getFrxOperationClass(FRXDO frxDO) {
        switch (frxDO.getCommitType()) {
            case Copied: {
                return "frx-copied";
            }
            case Moved: {
                return "frx-moved";
            }
            case Added: {
                return "frx-added";
            }
            case Deleted: {
                return "frx-deleted";
            }
        }
        return "frx-changed";
    }

    public static String getFrxLinkDescription(FRXDO frxDO) {
        switch (frxDO.getCommitType()) {
            case Copied: {
                return "Copied";
            }
            case Moved: {
                return "Moved";
            }
            case Added: {
                return "Added";
            }
            case Deleted: {
                return "Deleted";
            }
            case Modified: {
                return "Changed";
            }
        }
        return "";
    }
}

