/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.atlassian.fecru.utils.JasperUtils;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ListExpandoTag
extends BodyTagSupport {
    private String var;
    private Object shadowedVarValue;
    private String tag;
    private String sep;
    private String moreLink;
    private int currentItemIndex;
    private int visibleItemCount;
    private int totalItemCount;
    private Iterator iterator;
    private Object nextItem;
    private boolean sort;
    @Nullable
    private Object sortToFront;
    private List itemList;

    public void release() {
        this.var = null;
        this.shadowedVarValue = null;
        this.tag = null;
        this.moreLink = null;
        this.currentItemIndex = 0;
        this.visibleItemCount = 0;
        this.totalItemCount = 0;
        this.iterator = null;
        this.nextItem = null;
        super.release();
    }

    public void setItems(Object items) throws JspTagException {
        this.itemList = ExpressionUtil.asList(items);
        if (this.itemList == null) {
            throw new JspTagException(String.format("Expected an Array or Collection; received %s instead.", items.getClass().getCanonicalName()));
        }
    }

    public void setVar(String varName) {
        this.var = varName;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public void setWrapperTag(String tag) {
        this.tag = tag;
    }

    public void setMoreLink(String moreLink) {
        this.moreLink = moreLink;
    }

    public void setSep(String sep) {
        this.sep = sep;
    }

    public void setSort(boolean val) {
        this.sort = val;
    }

    public void setSortToFront(Object object) {
        this.sortToFront = object;
    }

    public int doStartTag() throws JspTagException {
        this.initialiseIterator();
        this.shadowedVarValue = this.pageContext.getAttribute(this.var);
        this.currentItemIndex = 1;
        if (this.tag == null) {
            this.tag = "span";
        }
        if (this.iterator.hasNext()) {
            this.nextItem = this.iterator.next();
            this.pageContext.setAttribute(this.var, this.nextItem);
            return 2;
        }
        return 0;
    }

    private void initialiseIterator() throws JspTagException {
        if (this.sort) {
            Collections.sort(this.itemList);
            if (this.sortToFront != null && this.itemList.contains(this.sortToFront)) {
                this.itemList.remove(this.sortToFront);
                this.itemList.add(0, this.sortToFront);
            }
        }
        this.iterator = this.itemList.iterator();
        this.totalItemCount = this.itemList.size();
    }

    public int doEndTag() throws JspTagException {
        this.pageContext.setAttribute(this.var, this.shadowedVarValue);
        try {
            if (this.totalItemCount > this.visibleItemCount + 1) {
                JspWriter out = this.pageContext.getOut();
                out.write("<span class=\"metadata-plus\">");
                String href = "";
                if (!StringUtils.isBlank((String)this.moreLink)) {
                    href = "href=\"" + StringEscapeUtils.escapeHtml((String)this.moreLink) + "\"";
                }
                out.write("(<a " + href + ">+");
                out.write(String.valueOf(this.totalItemCount - this.visibleItemCount));
                out.write(" more</a>)");
                out.write("</span>");
            }
            return super.doEndTag();
        }
        catch (Exception e2) {
            throw new JspTagException((Throwable)e2);
        }
    }

    private String getCssClass() {
        String cssClass = "";
        if (this.currentItemIndex > this.visibleItemCount && this.totalItemCount != this.visibleItemCount + 1) {
            cssClass = "hidden";
        }
        if (!this.iterator.hasNext()) {
            cssClass = cssClass + " last";
        }
        return cssClass;
    }

    public int doAfterBody() throws JspTagException {
        BodyContent body = this.getBodyContent();
        try {
            this.getPreviousOut().write("<" + this.tag + " class=\"" + this.getCssClass() + "\">");
            body.writeOut((Writer)this.getPreviousOut());
            JasperUtils.clearBody(this);
            if (this.iterator.hasNext() && !StringUtils.isBlank((String)this.sep)) {
                this.getPreviousOut().write(this.sep);
            }
            this.getPreviousOut().write("</" + this.tag + ">");
            if (this.iterator.hasNext()) {
                this.nextItem = this.iterator.next();
                ++this.currentItemIndex;
                this.pageContext.setAttribute(this.var, this.nextItem);
                return 2;
            }
            return 0;
        }
        catch (IOException e2) {
            throw new JspTagException((Throwable)e2);
        }
    }
}

